/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecoretools.validation;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import org.eclipse.acceleo.query.runtime.IQueryEnvironment;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecoretools.AleXtextPlugin;
import org.eclipse.emf.ecoretools.ale.OrderedSet;
import org.eclipse.emf.ecoretools.ale.SeqType;
import org.eclipse.emf.ecoretools.ale.Sequence;
import org.eclipse.emf.ecoretools.ale.SetType;
import org.eclipse.emf.ecoretools.ale.Unit;
import org.eclipse.emf.ecoretools.ale.core.diagnostics.IDiagnosticFormatter;
import org.eclipse.emf.ecoretools.ale.core.diagnostics.Message;
import org.eclipse.emf.ecoretools.ale.core.env.IAleEnvironment;
import org.eclipse.emf.ecoretools.ale.core.env.impl.FileBasedAleEnvironment;
import org.eclipse.emf.ecoretools.ale.core.interpreter.IAleInterpreter;
import org.eclipse.emf.ecoretools.ale.core.interpreter.impl.AleInterpreter;
import org.eclipse.emf.ecoretools.ale.core.io.IOResources;
import org.eclipse.emf.ecoretools.ale.core.parser.ParsedFile;
import org.eclipse.emf.ecoretools.ale.core.validation.ALEValidator;
import org.eclipse.emf.ecoretools.ale.core.validation.ITypeChecker;
import org.eclipse.emf.ecoretools.ale.core.validation.impl.TypeChecker;
import org.eclipse.emf.ecoretools.ale.ide.project.IAleProject;
import org.eclipse.emf.ecoretools.ale.implementation.ModelUnit;
import org.eclipse.emf.ecoretools.ale.validation.DiagnosticsToEditorMarkerAdapter;
import org.eclipse.emf.ecoretools.ale.validation.EditorMarkerFormatter;
import org.eclipse.emf.ecoretools.validation.AbstractAleValidator;
import org.eclipse.emf.workspace.util.WorkspaceSynchronizer;
import org.eclipse.xtext.Keyword;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.impl.HiddenLeafNode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.validation.Check;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

public class AleValidator
extends AbstractAleValidator {
    @Check
    public void checkIsValid(Unit root) {
        block10: {
            try {
                IFile aleFile = WorkspaceSynchronizer.getFile((Resource)root.eResource());
                this.cleanUpMarkers(aleFile);
                IProject project = aleFile.getProject();
                IAleEnvironment env = IAleProject.from((IProject)project).getEnvironment();
                IAleInterpreter _interpreter = env.getInterpreter();
                AleInterpreter interpreter = (AleInterpreter)_interpreter;
                try {
                    boolean aleFileIsNotInEnv;
                    String _name = project.getName();
                    interpreter.initScope((Set)Sets.newHashSet(), (Set)Sets.newHashSet((Object[])new String[]{_name}));
                    List parsedSemantics = env.getBehaviors().getParsedFiles();
                    Functions.Function1 _function = sem -> {
                        String _sourceFile = sem.getSourceFile();
                        File _file = new File(_sourceFile);
                        IFile _iFile = IOResources.toIFile((File)_file);
                        return Objects.equal((Object)aleFile, (Object)_iFile);
                    };
                    ParsedFile parsed = (ParsedFile)IterableExtensions.findFirst((Iterable)parsedSemantics, (Functions.Function1)_function);
                    boolean bl = aleFileIsNotInEnv = parsed == null;
                    if (aleFileIsNotInEnv) {
                        AleValidator.createFileNotInEnvMarker(aleFile);
                        return;
                    }
                    try {
                        Functions.Function1 _function_1 = it -> (ModelUnit)it.getRoot();
                        Functions.Function1 _function_2 = it -> it.getServices();
                        List services = IterableExtensions.toList((Iterable)Iterables.concat((Iterable)IterableExtensions.map((Iterable)IterableExtensions.filterNull((Iterable)ListExtensions.map((List)parsedSemantics, (Functions.Function1)_function_1)), (Functions.Function1)_function_2)));
                        interpreter.registerServices((Iterable)services);
                        ALEValidator validator = new ALEValidator(env);
                        validator.validate(parsedSemantics);
                        List msgs = validator.getMessages();
                        AleValidator.logInternalErrors(aleFile, msgs);
                        Function<String, IMarker> _function_3 = str -> {
                            try {
                                return aleFile.createMarker(str);
                            }
                            catch (Throwable _e) {
                                throw Exceptions.sneakyThrow((Throwable)_e);
                            }
                        };
                        IQueryEnvironment _context = env.getContext();
                        TypeChecker _typeChecker = new TypeChecker(null, _context);
                        EditorMarkerFormatter _editorMarkerFormatter = new EditorMarkerFormatter((ITypeChecker)_typeChecker);
                        DiagnosticsToEditorMarkerAdapter markerFactory = new DiagnosticsToEditorMarkerAdapter(_function_3, (IDiagnosticFormatter)_editorMarkerFormatter);
                        Functions.Function1 _function_4 = msg -> {
                            try {
                                boolean _not;
                                Optional file = env.getBehaviors().findParsedFileDefining((Object)msg.getSource());
                                boolean _isPresent = file.isPresent();
                                boolean bl = _not = !_isPresent;
                                if (_not) {
                                    return false;
                                }
                                String _sourceFile = ((ParsedFile)file.get()).getSourceFile();
                                File _file = new File(_sourceFile);
                                IFile _iFile = IOResources.toIFile((File)_file);
                                return Objects.equal((Object)_iFile, (Object)aleFile);
                            }
                            catch (Throwable _t) {
                                if (_t instanceof Exception) {
                                    Exception e = (Exception)_t;
                                    AleXtextPlugin.error("Unable to check whether the error comes from the current editor: " + msg, e);
                                    return true;
                                }
                                throw Exceptions.sneakyThrow((Throwable)_t);
                            }
                        };
                        Consumer<Message> _function_5 = msg -> markerFactory.doSwitch((EObject)msg);
                        IterableExtensions.filter((Iterable)msgs, (Functions.Function1)_function_4).forEach(_function_5);
                    }
                    catch (Throwable _t) {
                        if (_t instanceof Exception) {
                            Exception e = (Exception)_t;
                            IMarker marker = aleFile.createMarker("org.eclipse.emf.ecoretools.ale.xtext.AleMarker");
                            String _message = e.getMessage();
                            String _plus = "An internal error occurred while validating the file: " + _message;
                            marker.setAttribute("message", (Object)_plus);
                            marker.setAttribute("severity", 2);
                            marker.setAttribute("charStart", 0);
                            marker.setAttribute("charEnd", 0);
                            AleXtextPlugin.error("An internal error occurred while validating " + aleFile, e);
                            break block10;
                        }
                        throw Exceptions.sneakyThrow((Throwable)_t);
                    }
                }
                finally {
                    env.close();
                }
            }
            catch (Throwable _e) {
                throw Exceptions.sneakyThrow((Throwable)_e);
            }
        }
    }

    @Check
    public void checkSequenceInitialization(Sequence sequence) {
        this.checkNoExtraSpaceAfterKeyword(sequence, "Sequence", "Sequence initialization");
    }

    @Check
    public void checkOrderedSetInitialization(OrderedSet orderedSet) {
        this.checkNoExtraSpaceAfterKeyword(orderedSet, "OrderedSet", "OrderedSet initialization");
    }

    @Check
    public void checkSequenceTypeDeclaration(SeqType seqType) {
        this.checkNoExtraSpaceAfterKeyword(seqType, "Sequence", "Sequence type declaration");
    }

    @Check
    public void checkOrderedSetTypeDeclaration(SetType setType) {
        this.checkNoExtraSpaceAfterKeyword(setType, "OrderedSet", "OrderedSet type declaration");
    }

    public void checkNoExtraSpaceAfterKeyword(EObject grammarElement, String keyword, String message) {
        ICompositeNode node = NodeModelUtils.getNode((EObject)grammarElement);
        Functions.Function1 _function = it -> it.getGrammarElement() instanceof Keyword && ((Keyword)it.getGrammarElement()).getValue().equals(keyword);
        INode keywordNode = (INode)IterableExtensions.findFirst((Iterable)node.getChildren(), (Functions.Function1)_function);
        INode _nextSibling = keywordNode.getNextSibling();
        if (_nextSibling instanceof HiddenLeafNode) {
            this.getMessageAcceptor().acceptError("Extra space in " + message, grammarElement, keywordNode.getEndOffset(), keywordNode.getNextSibling().getLength(), "", new String[0]);
        }
    }

    private static void logInternalErrors(IFile aleFile, List<Message> messages) {
        Consumer<InternalError> _function = internalError -> {
            IPath _fullPath = aleFile.getFullPath();
            String _plus = "An internal error occurred during validation of " + _fullPath;
            AleXtextPlugin.error(_plus, internalError.getCause());
        };
        Iterables.filter(messages, InternalError.class).forEach(_function);
    }

    public static void resolveUris(FileBasedAleEnvironment dsl) {
        ArrayList newSemantics = new ArrayList();
        IWorkspace ws = ResourcesPlugin.getWorkspace();
        Consumer<String> _function = elem -> {
            URI uri = URI.createURI((String)elem);
            if (ws != null && uri.isPlatform()) {
                IResource file = ws.getRoot().findMember(uri.toPlatformString(true));
                String path = file.getLocationURI().getRawPath();
                newSemantics.add(path);
            } else {
                newSemantics.add(elem);
            }
        };
        dsl.getBehaviorsSources().forEach(_function);
        dsl.getBehaviorsSources().clear();
        dsl.getBehaviorsSources().addAll(newSemantics);
    }

    private void cleanUpMarkers(IFile file) {
        try {
            file.deleteMarkers("org.eclipse.emf.ecoretools.ale.xtext.AleMarker", true, 0);
            file.deleteMarkers("org.eclipse.emf.ecoretools.ale.xtext.SourceFileNotInEnvironmentMarker", true, 0);
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    private static void createFileNotInEnvMarker(IFile file) {
        try {
            IMarker marker = file.createMarker("org.eclipse.emf.ecoretools.ale.xtext.SourceFileNotInEnvironmentMarker");
            marker.setAttribute("message", (Object)"This file is not part of the project's ALE environment, it won't be validated");
            marker.setAttribute("severity", 1);
            marker.setAttribute("charStart", 0);
            marker.setAttribute("lineNumber", 0);
            String _string = file.getFullPath().toString();
            String _plus = "line: " + Integer.valueOf(0) + " " + _string;
            marker.setAttribute("location", (Object)_plus);
            marker.setAttribute("CODE_KEY", (Object)"org.eclipse.emf.ecoretools.ale.xtext.SourceFileNotInEnvironmentMarker");
            marker.setAttribute("COLUMN_KEY", 0);
            marker.setAttribute("URI_KEY", (Object)URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)true).toString());
            marker.setAttribute("FIXABLE_KEY", true);
            marker.setAttribute("charEnd", 0);
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }
}

