/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.aoste.timesquare.instantrelation.generator.metier;

import fr.inria.aoste.timesquare.instantrelation.CCSLRelationModel.CCSLConstraintRef;
import fr.inria.aoste.timesquare.instantrelation.CCSLRelationModel.CCSLRelationModelFactory;
import fr.inria.aoste.timesquare.instantrelation.CCSLRelationModel.Packet;
import fr.inria.aoste.timesquare.instantrelation.exceptions.ResolveClockConstraintException;
import fr.inria.aoste.timesquare.instantrelation.generator.metier.AbstractCreator;
import fr.inria.aoste.timesquare.instantrelation.generator.metier.Description;
import fr.inria.aoste.trace.EventOccurrence;
import fr.inria.aoste.trace.ModelElementReference;

public class CreatorPacket
extends AbstractCreator {
    final ModelElementReference clock;
    Packet relationPacket = null;
    final int size;

    public CreatorPacket(CCSLConstraintRef cref, ModelElementReference clock, int size) {
        super(cref);
        this.clock = clock;
        this.size = size;
    }

    public final synchronized ModelElementReference getClock() {
        return this.clock;
    }

    public final synchronized int getSize() {
        return this.size;
    }

    @Override
    public void resolve() throws ResolveClockConstraintException {
        EventOccurrence l = this.getEventOccurrenceOnStepTrace(this.clock);
        boolean b1 = this.clockTick(l);
        if (b1) {
            if (this.relationPacket == null) {
                this.relationPacket = CCSLRelationModelFactory.eINSTANCE.createPacket();
            }
            this.relationPacket.getOccurrences().add((Object)l);
            if (this.relationPacket.getOccurrences().size() == this.size) {
                this.addRelation(this.relationPacket);
                this.relationPacket = null;
            }
        }
    }

    @Override
    public Description createDescription() {
        return Description.createDescriptionPacket(this.clock, this.getCcslConstraintRef());
    }

    @Override
    public void finish() {
        if (this.relationPacket != null && this.relationPacket.getOccurrences().size() != 0) {
            this.addRelation(this.relationPacket);
        }
        this.relationPacket = null;
    }

    @Override
    protected void init() {
    }
}

