/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.executionframework.extensions.sirius.modelloader;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.gemoc.xdsmlframework.api.core.IExecutionCheckpoint;
import org.eclipse.sirius.ecore.extender.business.api.permission.IAuthorityListener;
import org.eclipse.sirius.ecore.extender.business.api.permission.LockStatus;
import org.eclipse.sirius.ecore.extender.business.internal.permission.AbstractPermissionAuthority;

public class DebugPermissionAuthority
extends AbstractPermissionAuthority
implements IExecutionCheckpoint {
    private static final Map<ResourceSet, Integer> allow = new HashMap<ResourceSet, Integer>();

    public void allow(ResourceSet rs, boolean allow) {
        Integer integer = DebugPermissionAuthority.allow.get(rs);
        if (allow) {
            if (integer == null) {
                DebugPermissionAuthority.allow.put(rs, 1);
            } else {
                DebugPermissionAuthority.allow.put(rs, integer + 1);
            }
        } else if (integer == null) {
            DebugPermissionAuthority.allow.put(rs, -1);
        } else {
            DebugPermissionAuthority.allow.put(rs, integer - 1);
        }
    }

    public boolean canEditFeature(EObject eObj, String featureName) {
        if (eObj.eResource() == null) {
            return true;
        }
        Integer integer = allow.get(eObj.eResource().getResourceSet());
        return integer != null && integer > 0;
    }

    public boolean canEditInstance(EObject eObj) {
        if (eObj.eResource() == null) {
            return true;
        }
        Integer integer = allow.get(eObj.eResource().getResourceSet());
        return integer != null && integer > 0;
    }

    public boolean canCreateIn(EObject eObj) {
        if (eObj.eResource() == null) {
            return true;
        }
        Integer integer = allow.get(eObj.eResource().getResourceSet());
        return integer != null && integer > 0;
    }

    public boolean canDeleteInstance(EObject target) {
        if (target.eResource() == null) {
            return true;
        }
        Integer integer = allow.get(target.eResource().getResourceSet());
        return integer != null && integer > 0;
    }

    public void notifyInstanceChange(EObject instance) {
    }

    public void notifyNewInstanceCreation(EObject instance) {
    }

    public void notifyInstanceDeletion(EObject instance) {
    }

    public void setReportIssues(boolean report) {
    }

    public void notifyLock(Collection<? extends EObject> elements) {
        for (IAuthorityListener listener : this.listeners) {
            listener.notifyIsLocked(elements);
        }
    }

    public void notifyUnlock(Collection<? extends EObject> elements) {
        for (IAuthorityListener listener : this.listeners) {
            listener.notifyIsReleased(elements);
        }
    }

    public LockStatus getLockStatus(EObject element) {
        return LockStatus.NOT_LOCKED;
    }
}

