/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.commons.eclipse.ui;

import org.eclipse.ui.IViewPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class ViewHelper {
    public static <ViewType> ViewType retrieveView(String viewId) {
        IViewPart viewPart = ViewHelper.retrieveViewPart(viewId, false);
        IViewPart view = null;
        try {
            view = viewPart;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return (ViewType)view;
    }

    public static <ViewType> ViewType showView(String viewId) {
        IViewPart viewPart = ViewHelper.retrieveViewPart(viewId, true);
        IViewPart view = null;
        try {
            view = viewPart;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return (ViewType)view;
    }

    public static IViewPart retrieveViewPart(String viewId, boolean forceFocus) {
        RetrieveViewPartRunnable runnable = new RetrieveViewPartRunnable(viewId, forceFocus);
        PlatformUI.getWorkbench().getDisplay().syncExec((Runnable)runnable);
        return runnable.getViewPart();
    }

    private static class RetrieveViewPartRunnable
    implements Runnable {
        private boolean _forceFocus = false;
        private String _viewId;
        private IViewPart _viewPart = null;

        public RetrieveViewPartRunnable(String viewId, boolean forceFocus) {
            this._viewId = viewId;
            this._forceFocus = forceFocus;
        }

        public IViewPart getViewPart() {
            return this._viewPart;
        }

        @Override
        public void run() {
            this._viewPart = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findView(this._viewId);
            if (this._viewPart == null || this._forceFocus) {
                try {
                    this._viewPart = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView(this._viewId);
                }
                catch (PartInitException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

