/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.ui.util;

public enum DifferenceKind {
    FROM_LEFT,
    FROM_LEFT_ADD,
    FROM_LEFT_DEL,
    FROM_RIGHT,
    FROM_RIGHT_ADD,
    FROM_RIGHT_DEL,
    FROM_BOTH,
    MODIFIED,
    CONFLICT,
    COUNTED,
    NONE;


    public boolean isAddition() {
        boolean result;
        switch (this) {
            case FROM_LEFT_ADD: 
            case FROM_RIGHT_ADD: {
                result = true;
                break;
            }
            default: {
                result = false;
            }
        }
        return result;
    }

    public boolean isModification() {
        boolean result;
        switch (this) {
            case FROM_LEFT: 
            case FROM_RIGHT: 
            case FROM_BOTH: 
            case MODIFIED: {
                result = true;
                break;
            }
            default: {
                result = false;
            }
        }
        return result;
    }

    public boolean isDeletion() {
        boolean result;
        switch (this) {
            case FROM_LEFT_DEL: 
            case FROM_RIGHT_DEL: {
                result = true;
                break;
            }
            default: {
                result = false;
            }
        }
        return result;
    }

    public boolean isLeft(boolean considerOrigin_p) {
        boolean result;
        switch (this) {
            case FROM_LEFT: 
            case FROM_LEFT_ADD: 
            case FROM_BOTH: 
            case MODIFIED: 
            case CONFLICT: {
                result = true;
                break;
            }
            case FROM_LEFT_DEL: {
                result = considerOrigin_p;
                break;
            }
            case FROM_RIGHT_DEL: {
                result = !considerOrigin_p;
                break;
            }
            default: {
                result = false;
            }
        }
        return result;
    }

    public boolean isNeutral() {
        return this == COUNTED || this == NONE;
    }

    public boolean isRight(boolean considerOrigin_p) {
        boolean result;
        switch (this) {
            case FROM_RIGHT: 
            case FROM_RIGHT_ADD: 
            case FROM_BOTH: 
            case MODIFIED: 
            case CONFLICT: {
                result = true;
                break;
            }
            case FROM_RIGHT_DEL: {
                result = considerOrigin_p;
                break;
            }
            case FROM_LEFT_DEL: {
                result = !considerOrigin_p;
                break;
            }
            default: {
                result = false;
            }
        }
        return result;
    }

    public DifferenceKind keepOnlyDirection(boolean considerOrigin_p) {
        DifferenceKind result;
        switch (this) {
            case FROM_LEFT: 
            case FROM_LEFT_ADD: 
            case FROM_LEFT_DEL: {
                result = considerOrigin_p ? FROM_LEFT : MODIFIED;
                break;
            }
            case FROM_RIGHT: 
            case FROM_RIGHT_ADD: 
            case FROM_RIGHT_DEL: {
                result = considerOrigin_p ? FROM_RIGHT : MODIFIED;
                break;
            }
            default: {
                result = this;
            }
        }
        return result;
    }

    public DifferenceKind with(DifferenceKind peer_p, boolean considerOrigin_p) {
        DifferenceKind result = this;
        if (peer_p != null) {
            result = peer_p == this ? this : (this == CONFLICT || peer_p == CONFLICT ? CONFLICT : (this == MODIFIED || peer_p == MODIFIED ? MODIFIED : (this == FROM_BOTH || peer_p == FROM_BOTH || this.isLeft(considerOrigin_p) && peer_p.isRight(considerOrigin_p) || this.isRight(considerOrigin_p) && peer_p.isLeft(considerOrigin_p) ? FROM_BOTH : (this.isLeft(considerOrigin_p) && peer_p.isLeft(considerOrigin_p) ? FROM_LEFT : (this.isRight(considerOrigin_p) && peer_p.isRight(considerOrigin_p) ? FROM_RIGHT : (this.isLeft(considerOrigin_p) || this.isRight(considerOrigin_p) ? this : (peer_p.isLeft(considerOrigin_p) || peer_p.isRight(considerOrigin_p) ? peer_p : (this == COUNTED || peer_p == COUNTED ? COUNTED : this))))))));
        }
        return result;
    }
}

