/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.aoste.timesquare.trace.util.adapter;

import fr.inria.aoste.timesquare.trace.util.HelperFactory;
import fr.inria.aoste.timesquare.trace.util.TimeBase;
import fr.inria.aoste.timesquare.trace.util.adapter.AdapterRegistry;
import fr.inria.aoste.timesquare.trace.util.adapter.DefaultModelAdapter;
import fr.inria.aoste.timesquare.trace.util.adapter.IModelAdapter;
import fr.inria.aoste.trace.ModelElementReference;
import java.util.HashMap;
import java.util.List;
import org.eclipse.emf.ecore.EObject;

class ModelElementReferenceModelAdapter
extends DefaultModelAdapter {
    static final ModelElementReferenceModelAdapter SINGLETON = new ModelElementReferenceModelAdapter();

    private ModelElementReferenceModelAdapter() {
    }

    @Override
    public boolean accept(EObject r) {
        return r instanceof ModelElementReference;
    }

    @Override
    public String getUID(EObject eo) {
        return this.getUID((ModelElementReference)eo);
    }

    private final String getUID(ModelElementReference mer) {
        if (mer.getElementRef().size() == 1) {
            EObject reference = HelperFactory.getFirstReference(mer);
            return AdapterRegistry.getAdapter(reference).getUID(reference);
        }
        StringBuilder sb = new StringBuilder();
        String prefix = "{";
        for (EObject er : mer.getElementRef()) {
            sb.append(prefix);
            sb.append(AdapterRegistry.getAdapter(er).getUID(er));
            prefix = ", ";
        }
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean isClock(EObject eo) {
        eo = HelperFactory.getLastReference((ModelElementReference)eo);
        return AdapterRegistry.getAdapter(eo).isClock(eo);
    }

    @Override
    public String getReferenceName(EObject clock) {
        return this.getReferenceName((ModelElementReference)clock);
    }

    private String getReferenceName(ModelElementReference mer) {
        StringBuilder sb = new StringBuilder("");
        String prefix = "";
        for (EObject er : mer.getElementRef()) {
            sb.append(prefix);
            sb.append(AdapterRegistry.getAdapter(er).getReferenceName(er));
            prefix = "::";
        }
        return sb.toString();
    }

    @Override
    public String getQualifiedName(EObject eo) {
        EObject ref = HelperFactory.getLastReference((ModelElementReference)eo);
        return AdapterRegistry.getAdapter(ref).getQualifiedName(ref);
    }

    @Override
    public List<EObject> fillWithReferencedElements(EObject reference, List<EObject> list) {
        return this.fillWithReferencedElements((ModelElementReference)reference, list);
    }

    private List<EObject> fillWithReferencedElements(ModelElementReference reference, List<EObject> list) {
        for (EObject o : reference.getElementRef()) {
            list = AdapterRegistry.getAdapter(o).fillWithReferencedElements(o, list);
        }
        return super.fillWithReferencedElements((EObject)reference, list);
    }

    @Override
    public boolean isDiscrete(EObject clock) {
        throw new RuntimeException("Operation not supported: isDiscrete not applicable to ModelElementReference:" + clock);
    }

    @Override
    public List<TimeBase> getDiscretyzeByValue(EObject clock) {
        clock = HelperFactory.getLastReference((ModelElementReference)clock);
        return AdapterRegistry.getAdapter(clock).getDiscretyzeByValue(clock);
    }

    @Override
    public HashMap<EObject, EObject> getDiscretyze(EObject r) {
        throw new RuntimeException("Operation not supported: getDiscretyze not applicable to ModelElementReference:" + r);
    }

    @Override
    public IModelAdapter.EventEnumerator getEventkind(EObject r) {
        throw new RuntimeException("Operation not supported: getEventKind not applicable to ModelElementReference:" + r);
    }
}

