/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecoretools.ale.ide.project.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecoretools.ale.core.env.IAleEnvironment;
import org.eclipse.emf.ecoretools.ale.core.env.impl.FileBasedAleEnvironment;
import org.eclipse.emf.ecoretools.ale.ide.Activator;
import org.eclipse.emf.ecoretools.ale.ide.project.AleProjectPreferences;
import org.eclipse.emf.ecoretools.ale.ide.project.IAleProject;

public class AleProject
implements IAleProject {
    public static final String CORE_PLUGIN_ID = "org.eclipse.emf.ecoretools.ale.core";
    private final IProject project;

    public AleProject(IProject project) {
        this.project = Objects.requireNonNull(project, "project");
    }

    @Override
    public boolean isConfiguredFromPreferences() {
        ProjectScope context = new ProjectScope(this.project);
        IEclipsePreferences preferences = context.getNode(CORE_PLUGIN_ID);
        return !preferences.getBoolean(AleProjectPreferences.CONFIGURED_FROM_DSL_FILE.property(), false);
    }

    @Override
    public Optional<IFile> findDslFile() {
        if (this.isConfiguredFromPreferences()) {
            return Optional.empty();
        }
        ProjectScope context = new ProjectScope(this.project);
        IEclipsePreferences preferences = context.getNode(CORE_PLUGIN_ID);
        try {
            String dslFilePath = preferences.get(AleProjectPreferences.DSL_FILE_PATH.property(), "");
            URI dslFileURI = URI.createURI((String)dslFilePath, (boolean)true);
            IResource dslFile = this.project.getWorkspace().getRoot().findMember(dslFileURI.toPlatformString(true));
            if (dslFile instanceof IFile) {
                return Optional.of((IFile)dslFile);
            }
            return Optional.empty();
        }
        catch (IllegalArgumentException | NullPointerException e) {
            return Optional.empty();
        }
    }

    @Override
    public IProject getProject() {
        return this.project;
    }

    @Override
    public IAleEnvironment getEnvironment() {
        ProjectScope context = new ProjectScope(this.project);
        IEclipsePreferences preferences = context.getNode(CORE_PLUGIN_ID);
        try {
            if (this.isConfiguredFromPreferences()) {
                return this.environmentFromProjectPreferences(preferences);
            }
            return this.environmentFromDslConfigurationFile(preferences);
        }
        catch (IOException | IllegalArgumentException e) {
            Activator.error("Cannot load ALE environment of project '" + this.project.getName() + "'", e);
            return IAleEnvironment.fromPaths(new ArrayList(0), new ArrayList(0));
        }
    }

    private IAleEnvironment environmentFromDslConfigurationFile(IEclipsePreferences preferences) throws IOException {
        IFile file = this.findDslFile().orElseThrow(() -> new IllegalArgumentException("Cannot load DSL file"));
        try {
            return new FileBasedAleEnvironment(file.getContents());
        }
        catch (CoreException e) {
            throw new IOException("Unable to read the content of the DSL configuration file");
        }
    }

    private IAleEnvironment environmentFromProjectPreferences(IEclipsePreferences preferences) {
        String aleSourceFilesPath = preferences.get(AleProjectPreferences.ALE_SOURCE_FILES.property(), "");
        String ecoreModelFilesPath = preferences.get(AleProjectPreferences.ECORE_MODEL_FILES.property(), "");
        List<String> sourceFiles = Arrays.asList(aleSourceFilesPath.split(","));
        List<String> ecoreModels = Arrays.asList(ecoreModelFilesPath.split(","));
        return IAleEnvironment.fromPaths(ecoreModels, sourceFiles);
    }
}

