/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.aoste.timesquare.vcd.dialogs;

import fr.inria.aoste.timesquare.vcd.IVcdDiagram;
import fr.inria.aoste.timesquare.vcd.model.IVar;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.resource.StringConverter;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class FindDialog
extends Dialog {
    private IVcdDiagram _vcdDiagram;
    private String _title;
    private String _message;
    private String _value = "";
    private String _value2 = "";
    private Button _okButton;
    private CCombo _combo;
    private Text _text2;
    private Text _errorMessageText;
    private String _errorMessage;
    private String _message2;
    private int[] _clockedge = null;
    private int _max = 0;
    String[] _clocknames = null;

    protected void validateInput() {
        if (this._combo.getSelectionIndex() != -1) {
            int sel = this._combo.getSelectionIndex();
            if (sel != -1 && this._clockedge != null && sel < this._clockedge.length) {
                this._max = this._clockedge[sel];
                this.setErrorMessage("Clock  " + this._combo.getItem(sel) + " have  " + this._max + "  edge(s) ", ColorConstants.black);
            } else {
                this._max = 0;
            }
            String s = this._text2.getText();
            if (s == null || s.equals("")) {
                this._okButton.setEnabled(false);
            } else {
                int n = Integer.parseInt(s);
                if (n < this._max + 1 && n != 0) {
                    this._okButton.setEnabled(true);
                    this.setErrorMessage("Clock  " + this._combo.getItem(sel) + " have  " + this._max + "  edge(s) ", ColorConstants.black);
                } else {
                    this._okButton.setEnabled(false);
                    this.setErrorMessage("ERROR : Clock  " + this._combo.getItem(sel) + " have  " + this._max + "  edge(s) ", ColorConstants.red);
                }
            }
        } else {
            this.setErrorMessage("Warning : no clock selected ", ColorConstants.darkBlue);
            this._okButton.setEnabled(false);
        }
    }

    protected Button getOkButton() {
        return this._okButton;
    }

    protected void buttonPressed(int buttonId) {
        try {
            if (buttonId == 0) {
                int n = this._combo.getSelectionIndex();
                if (n != -1 && this._clocknames != null && n < this._clocknames.length) {
                    this._value = this._clocknames[n];
                }
                this._value2 = this._text2.getText();
                System.out.println("--->" + this._value + "<--" + n);
            } else {
                this._value = null;
                this._value2 = null;
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        super.buttonPressed(buttonId);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        if (this._title != null) {
            shell.setText(this._title);
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this._okButton = this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this._okButton.setEnabled(false);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        GridData data = new GridData(1796);
        data.widthHint = this.convertHorizontalDLUsToPixels(300);
        if (this._message != null) {
            Label label = new Label(composite, 64);
            label.setText(this._message);
            label.setLayoutData((Object)data);
            label.setFont(parent.getFont());
        }
        this._combo = new CCombo(composite, 8);
        this._combo.setBackground(new Color(null, 255, 255, 255));
        int size = this._vcdDiagram.getTraceCollector().getSelectedClocks().size();
        String[] clockalias = new String[size];
        this._clocknames = new String[size];
        this._clockedge = new int[size];
        int i = 0;
        for (IVar var : this._vcdDiagram.getTraceCollector().getSelectedClocks()) {
            int n = 0;
            if (var.getValueFactory() != null) {
                n = var.getValueFactory().getEdge();
            }
            clockalias[i] = var.getAliasName();
            this._clocknames[i] = var.getName();
            this._clockedge[i] = n;
            ++i;
        }
        this._combo.setItems(clockalias);
        this._combo.setLayoutData((Object)new GridData(768));
        this._combo.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                FindDialog.this.validateInput();
            }
        });
        if (this._message2 != null) {
            Label label = new Label(composite, 64);
            label.setText(this._message2);
            data.widthHint = this.convertHorizontalDLUsToPixels(300);
            label.setLayoutData((Object)data);
            label.setFont(parent.getFont());
        }
        this._text2 = new Text(composite, 2052);
        this._text2.setLayoutData((Object)new GridData(768));
        this._text2.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                FindDialog.this.validateInput();
            }
        });
        this._text2.addListener(25, (Listener)new ListernerInt());
        this._errorMessageText = new Text(composite, 72);
        this._errorMessageText.setLayoutData((Object)new GridData(768));
        this._errorMessageText.setBackground(this._errorMessageText.getDisplay().getSystemColor(22));
        this.setErrorMessage(this._errorMessage, ColorConstants.black);
        FindDialog.applyDialogFont((Control)composite);
        return composite;
    }

    public FindDialog(Shell parentShell, String dialogTitle, String dialogMessage, String dialogMessage2, String initialValue, IVcdDiagram vdt) {
        super(parentShell);
        this._title = dialogTitle;
        this._message = dialogMessage;
        this._message2 = dialogMessage2;
        this._value = initialValue == null ? "" : initialValue;
        this._vcdDiagram = vdt;
    }

    public String getClock() {
        return this._value;
    }

    public String getInstance() {
        try {
            int n = Integer.parseInt(this._value2);
            return "" + (n - 1);
        }
        catch (Throwable e) {
            return null;
        }
    }

    public String getMessage2() {
        return this._message2;
    }

    public void setMessage2(String message2) {
        this._message2 = message2;
    }

    public void setErrorMessage(String errorMessage, Color c) {
        this._errorMessage = errorMessage;
        if (this._errorMessageText != null && !this._errorMessageText.isDisposed()) {
            this._errorMessageText.setText(errorMessage == null ? " \n " : errorMessage);
            boolean hasError = errorMessage != null && StringConverter.removeWhiteSpaces((String)errorMessage).length() > 0;
            this._errorMessageText.setEnabled(hasError);
            this._errorMessageText.setVisible(hasError);
            this._errorMessageText.setForeground(c);
            this._errorMessageText.getParent().update();
        }
    }

    public static class ListernerInt
    implements Listener {
        public void handleEvent(Event e) {
            String string = e.text;
            char[] chars = new char[string.length()];
            string.getChars(0, chars.length, chars, 0);
            int i = 0;
            while (i < chars.length) {
                if ('0' > chars[i] || chars[i] > '9') {
                    e.doit = false;
                    return;
                }
                ++i;
            }
        }
    }
}

