/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.aoste.timesquare.vcd.view.constraint;

import fr.inria.aoste.timesquare.utils.console.ErrorConsole;
import fr.inria.aoste.timesquare.vcd.ListConnections;
import fr.inria.aoste.timesquare.vcd.model.VCDDefinitions;
import fr.inria.aoste.timesquare.vcd.model.comment.IConstraintData;
import fr.inria.aoste.timesquare.vcd.preferences.VcdColorPreferences;
import fr.inria.aoste.timesquare.vcd.view.IConstructContraint;
import fr.inria.aoste.timesquare.vcd.view.VcdFactory;
import fr.inria.aoste.timesquare.vcd.view.constraint.IConstraint;
import fr.inria.aoste.timesquare.vcd.view.figure.ExtendFigure;
import java.util.ArrayList;
import org.eclipse.jface.action.Action;

public abstract class AbsConstraint
implements IConstraint {
    protected VcdFactory vcdFactory = null;
    protected VCDDefinitions vcddef = null;
    protected IConstraintData cc = null;
    protected ListConnections list;
    protected IConstructContraint icc;
    protected boolean isConstraintVisible = false;
    protected boolean isGlobal = false;
    protected VcdColorPreferences mca;
    protected int testn = 1;

    @Override
    public VcdColorPreferences getMca() {
        return this.mca;
    }

    @Override
    public void setMca(VcdColorPreferences mca) {
        this.mca = mca;
    }

    @Override
    public final VcdFactory getVcdFactory() {
        return this.vcdFactory;
    }

    @Override
    public final void setVcdFactory(VcdFactory vcdFactory) {
        this.vcdFactory = vcdFactory;
        if (vcdFactory != null) {
            this.mca = vcdFactory.getMca();
            this.vcddef = vcdFactory.getVcdDefinitions();
            if (this.vcddef == null) {
                ErrorConsole.println((String)"Warning VCDDef is null");
            }
        }
    }

    @Override
    public IConstraintData getCc() {
        return this.cc;
    }

    @Override
    public final void setCc(IConstraintData cc) {
        this.cc = cc;
    }

    @Override
    public final ListConnections getList() {
        return this.list;
    }

    @Override
    public final void setList(ListConnections list) {
        this.list = list;
    }

    @Override
    public final IConstructContraint getIcc() {
        return this.icc;
    }

    @Override
    public final void setIcc(IConstructContraint icc) {
        this.icc = icc;
    }

    @Override
    public final boolean getIsConstraintVisible() {
        return this.isConstraintVisible;
    }

    @Override
    public final void setIsConstraintVisible(boolean b) {
        this.isConstraintVisible = b;
    }

    @Override
    public final boolean haveAllClockVisible() {
        if (this.cc.getClock() == null) {
            return true;
        }
        if (this.vcdFactory.getNameforfigures().get(this.cc.getClock()) == null) {
            return false;
        }
        if (this.cc.getReferenceClocks() == null || this.cc.getReferenceClocks().size() == 0) {
            return true;
        }
        if (this.vcdFactory.getNameforfigures().get(this.cc.getReferenceClocks().get(0)) == null) {
            return false;
        }
        return this.testn < 2 || this.vcdFactory.getNameforfigures().get(this.cc.getReferenceClocks().get(1)) != null;
    }

    protected final ExtendFigure getTick(String clock, int num) {
        if (num < 0) {
            return null;
        }
        ArrayList<ExtendFigure> ticks = this.vcdFactory.getNameforfigures().get(clock);
        if (num < ticks.size()) {
            return ticks.get(num);
        }
        return null;
    }

    protected final int getIndice(String clock, ExtendFigure figure) {
        ArrayList<ExtendFigure> ticks = this.vcdFactory.getNameforfigures().get(clock);
        return ticks.indexOf(figure);
    }

    protected void finalize() throws Throwable {
        if (this.list != null) {
            this.list.clearAll();
            this.list.clear();
        }
        super.finalize();
    }

    public Action[] getAction() {
        return new Action[0];
    }
}

