/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.aoste.timesquare.vcd.view.constraint;

import fr.inria.aoste.timesquare.utils.console.ErrorConsole;
import fr.inria.aoste.timesquare.vcd.IVcdDiagram;
import fr.inria.aoste.timesquare.vcd.figure.ConstraintsConnection;
import fr.inria.aoste.timesquare.vcd.view.constraint.AbsConstraint;
import fr.inria.aoste.timesquare.vcd.view.constraint.IConstraint;
import fr.inria.aoste.timesquare.vcd.view.figure.Draw1;
import fr.inria.aoste.timesquare.vcd.view.figure.ExtendFigure;
import java.util.ArrayList;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;

public class ConstraintSampledOn
extends AbsConstraint
implements IConstraint {
    boolean weakly = false;
    int c1 = -1;
    int c2a = -1;
    int c2b = -1;
    int c3 = 1;
    String clk1 = null;
    String clk2 = null;
    String clk3 = null;
    ArrayList<ExtendFigure> figures1 = null;
    ArrayList<ExtendFigure> figures2 = null;
    ArrayList<ExtendFigure> figures3 = null;

    public ConstraintSampledOn() {
        this.testn = 2;
    }

    public final boolean isWeakly() {
        return this.weakly;
    }

    public final void setWeakly(boolean weakly) {
        this.weakly = weakly;
    }

    @Override
    public int draw(Draw1 currentfig, String currentclock) {
        try {
            this.c3 = -1;
            this.c2b = -1;
            this.c2a = -1;
            this.c1 = -1;
            int cas = 0;
            this.clk1 = this.cc.getClock();
            this.clk2 = this.cc.getReferenceClocks().get(0);
            this.clk3 = this.cc.getReferenceClocks().get(1);
            this.figures1 = this.vcdFactory.getNameforfigures().get(this.clk1);
            this.figures2 = this.vcdFactory.getNameforfigures().get(this.clk2);
            this.figures3 = this.vcdFactory.getNameforfigures().get(this.clk3);
            if (currentclock.equals(this.clk1)) {
                cas = 1;
            }
            if (currentclock.equals(this.clk2)) {
                cas = 2;
            }
            if (currentclock.equals(this.clk3)) {
                cas = 3;
            }
            int x = currentfig.getLocation().x;
            if (this.weakly) {
                switch (cas) {
                    case 1: {
                        this.c1 = this.vcdFactory.getNameforfigures().get(this.clk1).indexOf(currentfig);
                        this.c2a = this.icc.lastBefore(this.clk2, x);
                        this.c2b = this.icc.synchrone(this.clk2, x);
                        this.c3 = this.icc.lastBefore(this.clk3, x);
                        break;
                    }
                    case 2: {
                        this.c2b = this.vcdFactory.getNameforfigures().get(this.clk2).indexOf(currentfig);
                        this.c2a = this.c2b - 1;
                        this.c1 = this.icc.synchrone(this.clk1, x);
                        this.c3 = this.icc.lastBefore(this.clk3, x);
                        break;
                    }
                    case 3: {
                        this.c3 = this.vcdFactory.getNameforfigures().get(this.clk3).indexOf(currentfig);
                        this.c2a = this.icc.lastBeforeweak(this.clk2, x);
                        this.c2b = this.icc.firstAfter(this.clk2, x);
                        this.c1 = this.icc.firstAfter(this.clk1, x);
                        break;
                    }
                }
            } else {
                switch (cas) {
                    case 1: {
                        this.c1 = this.vcdFactory.getNameforfigures().get(this.clk1).indexOf(currentfig);
                        this.c2a = this.icc.lastBefore(this.clk2, x);
                        this.c2b = this.icc.synchrone(this.clk2, x);
                        this.c3 = this.icc.lastBefore(this.clk3, x);
                        break;
                    }
                    case 2: {
                        this.c2b = this.vcdFactory.getNameforfigures().get(this.clk2).indexOf(currentfig);
                        this.c2a = this.c2b - 1;
                        this.c1 = this.icc.synchrone(this.clk1, x);
                        this.c3 = this.icc.lastBefore(this.clk3, x);
                        break;
                    }
                    case 3: {
                        this.c3 = this.vcdFactory.getNameforfigures().get(this.clk3).indexOf(currentfig);
                        this.c2a = this.icc.lastBefore(this.clk2, x);
                        this.c2b = this.icc.firstAfterStrict(this.clk2, x);
                        this.c1 = this.icc.firstAfter(this.clk1, x);
                        break;
                    }
                }
            }
            this.displaySync();
            return 0;
        }
        catch (Throwable e) {
            return -1;
        }
    }

    private int displaySync() {
        ConstraintsConnection poly2;
        if (this.c1 != -1 && this.c2b != -1) {
            ConstraintsConnection poly = this.icc.constructCoincidenceConnection(this.mca.colorRedCoincidence(), (Draw1)this.figures1.get(this.c1), (Draw1)this.figures2.get(this.c2b));
            poly.setComment(this.cc);
            poly.setGlobal(this.isGlobal);
            this.icc.addToList(this.list.getListConstraints(), poly);
        }
        if (this.c3 != -1 && this.c2a != -1 && this.c1 != -1) {
            poly2 = this.icc.constructDashConnection(this.mca.colorWhiteArrow(), (Draw1)this.figures2.get(this.c2a), (Draw1)this.figures3.get(this.c3), false);
            poly2.setComment(this.cc);
            poly2.setGlobal(this.isGlobal);
            this.icc.addToList(this.list.getListConstraints(), poly2);
        }
        if (this.c3 != -1 && this.c2b != -1 && this.c1 != -1) {
            poly2 = this.icc.constructDashConnection(this.mca.colorWhiteArrow(), (Draw1)this.figures3.get(this.c3), (Draw1)this.figures2.get(this.c2b), false);
            poly2.setComment(this.cc);
            poly2.setGlobal(this.isGlobal);
            this.icc.addToList(this.list.getListConstraints(), poly2);
        }
        return 0;
    }

    @Override
    public int drawTableItemConstraints() {
        String nameClock;
        block6: {
            this.isGlobal = true;
            nameClock = this.cc.getClock();
            if (this.haveAllClockVisible()) {
                for (IFigure iFigure : this.vcdFactory.getNameforfigures().get(nameClock)) {
                    this.draw((Draw1)iFigure, nameClock);
                }
                break block6;
            }
            return -1;
        }
        try {
            IVcdDiagram iVcdDiagram = this.vcdFactory.getVcddia();
            for (IFigure iFigure : this.list.getListConstraints()) {
                Dimension dim = iVcdDiagram.getCanvas().getContents().getPreferredSize();
                iVcdDiagram.getCanvas().getContents().add(iFigure);
                Rectangle bounds = iFigure.getBounds();
                iVcdDiagram.getCanvas().redraw(bounds.x, bounds.y, bounds.width, bounds.height, true);
                iVcdDiagram.getCanvas().getContents().setPreferredSize(dim);
            }
            this.isConstraintVisible = true;
            this.isGlobal = false;
            return this.vcdFactory.getNameforfigures().get(nameClock).size();
        }
        catch (Throwable t) {
            ErrorConsole.printError((Throwable)t);
            this.isGlobal = false;
            return -1;
        }
    }

    @Override
    public int drawOneTick(int ticknum, String clockId) {
        return 0;
    }
}

