/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.execution.concurrent.ccsljavaengine.ui.views.stimulimanager.scenario;

import org.eclipse.core.runtime.IPath;
import org.eclipse.gemoc.execution.concurrent.ccsljavaengine.ui.views.stimulimanager.ModelSpecificEventContext;
import org.eclipse.gemoc.execution.concurrent.ccsljavaengine.ui.views.stimulimanager.scenario.ScenarioException;
import org.eclipse.gemoc.execution.concurrent.ccsljavaengine.ui.views.stimulimanager.scenario.ScenarioManagerState;
import org.eclipse.gemoc.execution.concurrent.ccsljavaengine.ui.views.stimulimanager.scenario.ScenarioPlayer;
import org.eclipse.gemoc.execution.concurrent.ccsljavaengine.ui.views.stimulimanager.scenario.ScenarioRecorder;

public class ScenarioManager {
    private ScenarioRecorder _recorder;
    private ScenarioPlayer _player;
    private ModelSpecificEventContext _mseContext;
    private ScenarioManagerState _state = ScenarioManagerState.Idle;

    public ScenarioManager(ModelSpecificEventContext mseContext) {
        this._mseContext = mseContext;
    }

    public ScenarioManagerState getState() {
        return this._state;
    }

    public void startRecord() {
        this._state = ScenarioManagerState.Recording;
        this._recorder = new ScenarioRecorder(this._mseContext);
        this._recorder.startRecord();
    }

    public void record() {
        if (this._recorder != null) {
            this._recorder.record();
        }
    }

    public void stopRecord() {
        this._state = ScenarioManagerState.Idle;
    }

    public void startPlaying(IPath path) {
        this._state = ScenarioManagerState.Playing;
        this._player = new ScenarioPlayer(this._mseContext);
        this._player.load(path);
        this.play();
    }

    public void play() {
        if (this._player != null) {
            try {
                if (!this._player.play()) {
                    this.stopPlaying();
                }
            }
            catch (ScenarioException e) {
                this.stopPlaying();
            }
        }
    }

    public void stopPlaying() {
        if (this._player != null) {
            this._player.stop();
        }
        this._state = ScenarioManagerState.Idle;
    }

    public ModelSpecificEventContext getCache() {
        return this._mseContext;
    }
}

