/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecoretools.ale.ide.ui.io;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.ecoretools.ale.ide.ui.Activator;
import org.eclipse.emf.ecoretools.ale.ide.ui.io.AleConsole;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.console.IHyperlink;
import org.eclipse.ui.console.IPatternMatchListenerDelegate;
import org.eclipse.ui.console.PatternMatchEvent;
import org.eclipse.ui.console.TextConsole;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.texteditor.ITextEditor;

public class HyperlinkAleConsoleMatcherListener
implements IPatternMatchListenerDelegate {
    private TextConsole console;

    public void connect(TextConsole console) {
        if (console instanceof AleConsole) {
            this.console = console;
        }
    }

    public void disconnect() {
        this.console = null;
    }

    public void matchFound(PatternMatchEvent event) {
        if (!this.isInAleConsole()) {
            return;
        }
        try {
            String fileReferenceText = this.console.getDocument().get(event.getOffset(), event.getLength());
            int filePathIndex = this.startIndexIn(fileReferenceText);
            int separatorIndex = fileReferenceText.lastIndexOf(58);
            String absoluteFilePath = fileReferenceText.substring(filePathIndex, separatorIndex);
            int lineNumber = Integer.parseInt(fileReferenceText.substring(separatorIndex + 1));
            IHyperlink hyperlink = HyperlinkAleConsoleMatcherListener.makeHyperlink(absoluteFilePath, lineNumber);
            this.console.addHyperlink(hyperlink, event.getOffset() + filePathIndex, event.getLength() - filePathIndex);
        }
        catch (NumberFormatException fileReferenceText) {
        }
        catch (Exception exception) {
            Activator.error("Unable to create hyperlink from " + event.getOffset() + " to " + event.getLength(), exception);
        }
    }

    private int startIndexIn(String fileReferenceText) {
        return fileReferenceText.toLowerCase().indexOf("at ") + "at ".length();
    }

    private boolean isInAleConsole() {
        return this.console != null;
    }

    private static IHyperlink makeHyperlink(String absoluteFilePath, int lineNumber) {
        return new AleConsoleHyperlink(absoluteFilePath, lineNumber);
    }

    private static final class AleConsoleHyperlink
    implements IHyperlink {
        private final String absoluteFilePath;
        private final int lineNumber;

        private AleConsoleHyperlink(String absoluteFilePath, int lineNumber) {
            this.absoluteFilePath = absoluteFilePath;
            this.lineNumber = lineNumber;
        }

        public void linkExited() {
        }

        public void linkEntered() {
        }

        public void linkActivated() {
            IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            try {
                IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(this.absoluteFilePath));
                IEditorPart editorPart = IDE.openEditor((IWorkbenchPage)page, (IFile)file);
                AleConsoleHyperlink.goToLine(editorPart, this.lineNumber);
            }
            catch (Exception exception) {
                Activator.error("Unable to open an editor when hyperlinked to " + this.absoluteFilePath + ":" + this.lineNumber + " has been triggered", exception);
            }
        }

        private static void goToLine(IEditorPart editorPart, int lineNumber) {
            ITextEditor textEditor;
            IDocument document;
            if (editorPart instanceof ITextEditor && (document = (textEditor = (ITextEditor)editorPart).getDocumentProvider().getDocument((Object)textEditor.getEditorInput())) != null) {
                IRegion region = null;
                try {
                    region = document.getLineInformation(lineNumber - 1);
                    textEditor.selectAndReveal(region.getOffset(), region.getLength());
                }
                catch (BadLocationException exception) {
                    Activator.error("Unable to go to line " + lineNumber + " in editor " + editorPart, exception);
                }
            }
        }
    }
}

