/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.aoste.timesquare.ccslkernel.solver.extension.alternates;

import fr.inria.aoste.timesquare.ccslkernel.runtime.ICCSLConstraint;
import fr.inria.aoste.timesquare.ccslkernel.runtime.SerializedConstraintState;
import fr.inria.aoste.timesquare.ccslkernel.runtime.elements.RuntimeClock;
import fr.inria.aoste.timesquare.ccslkernel.runtime.exceptions.SimulationException;
import fr.inria.aoste.timesquare.ccslkernel.runtime.helpers.AbstractSemanticHelper;
import fr.inria.aoste.timesquare.ccslkernel.runtime.helpers.AbstractUpdateHelper;
import fr.inria.aoste.timesquare.ccslkernel.solver.TimeModel.SolverClock;
import fr.inria.aoste.timesquare.ccslkernel.solver.relation.AbstractWrappedRelation;

public class BlackboxAlternates
extends AbstractWrappedRelation {
    private AlternatesState state = AlternatesState.INHIBIT_RIGHT;
    private SolverClock leftClock;
    private SolverClock rightClock;

    public void start(AbstractSemanticHelper helper) throws SimulationException {
        this.state = AlternatesState.INHIBIT_RIGHT;
    }

    public void semantic(AbstractSemanticHelper semanticHelper) throws SimulationException {
        if (semanticHelper.isSemanticDone((ICCSLConstraint)this)) {
            return;
        }
        semanticHelper.registerSemanticDone((ICCSLConstraint)this);
        switch (this.state) {
            case INHIBIT_LEFT: {
                semanticHelper.semanticBDDAnd(semanticHelper.createNot((RuntimeClock)this.leftClock));
                break;
            }
            case INHIBIT_RIGHT: {
                semanticHelper.semanticBDDAnd(semanticHelper.createNot((RuntimeClock)this.rightClock));
            }
        }
        semanticHelper.registerClockUse((RuntimeClock[])new SolverClock[]{this.leftClock, this.rightClock});
    }

    public void deathSemantic(AbstractSemanticHelper helper) throws SimulationException {
    }

    public void setLeftClock(SolverClock leftClock) {
        this.leftClock = leftClock;
    }

    public void setRightClock(SolverClock rightClock) {
        this.rightClock = rightClock;
    }

    public void update(AbstractUpdateHelper helper) throws SimulationException {
        switch (this.state) {
            case INHIBIT_LEFT: {
                if (!helper.clockHasFired((RuntimeClock)this.rightClock)) break;
                this.state = AlternatesState.INHIBIT_RIGHT;
                break;
            }
            case INHIBIT_RIGHT: {
                if (!helper.clockHasFired((RuntimeClock)this.leftClock)) break;
                this.state = AlternatesState.INHIBIT_LEFT;
            }
        }
    }

    public SerializedConstraintState dumpState() {
        SerializedConstraintState state = super.dumpState();
        state.dump((Object)this.state.ordinal());
        return state;
    }

    public void restoreState(SerializedConstraintState state) {
        super.restoreState(state);
        this.state = AlternatesState.values()[(Integer)state.restore(0)];
    }

    protected ICCSLConstraint[] getConstraints() {
        return null;
    }

    public void assertionSemantic(AbstractSemanticHelper helper) {
    }

    private static enum AlternatesState {
        INHIBIT_LEFT,
        INHIBIT_RIGHT;

    }
}

