/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.commons.eclipse.messagingsystem.ui.helper;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Hashtable;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.gemoc.commons.eclipse.messagingsystem.ui.helper.FileHelpers;
import org.eclipse.gemoc.commons.eclipse.messagingsystem.ui.helper.PropertyNotFoundException;
import org.eclipse.gemoc.commons.eclipse.messagingsystem.ui.helper.URIHelper;

public class ResourceHelpers {
    public static final IWorkspace workspace = ResourcesPlugin.getWorkspace();
    public static final IWorkspaceRoot root = workspace.getRoot();

    private static String cleanIfNecessaryPath(String resourcePath) {
        String unifiedSepratorResourcePath;
        String cleanPath = unifiedSepratorResourcePath = resourcePath.replaceAll("\\\\", "/");
        if (unifiedSepratorResourcePath.matches("platform:/resource.*")) {
            cleanPath = URIHelper.getPathFromPlatformURI(resourcePath);
        } else if (unifiedSepratorResourcePath.matches("file:/.*")) {
            String rootPath = "";
            rootPath = unifiedSepratorResourcePath.matches("file:/.:/.+") ? "file:/" + root.getLocation().toString().replaceAll(" ", "%20") : "file:" + root.getLocation().toString();
            cleanPath = unifiedSepratorResourcePath.replace(rootPath, "");
        }
        return cleanPath;
    }

    public static IFile getIFile(String filePath) {
        return ResourceHelpers.getIFile(filePath, true);
    }

    public static IFile getIFile(String filePath, boolean checkExistency) {
        String cleanPath = ResourceHelpers.cleanIfNecessaryPath(filePath);
        Path path = new Path(cleanPath);
        try {
            IFile file = root.getFile((IPath)path);
            if (!checkExistency) {
                return file;
            }
            if (file.exists()) {
                return file;
            }
            return null;
        }
        catch (IllegalArgumentException exception) {
            return null;
        }
    }

    public static IFile getOrCreateIFile(String filePath) {
        String cleanPath = ResourceHelpers.cleanIfNecessaryPath(filePath);
        Path path = new Path(cleanPath);
        try {
            IFile file = root.getFile((IPath)path);
            return file;
        }
        catch (IllegalArgumentException exception) {
            return null;
        }
    }

    public static IResource getIResourceFromURL(URL url) {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IResource ifile = workspace.getRoot().findMember(FileHelpers.URLToStringWithoutFile(url));
        if (ifile == null && url.getProtocol().equals("file")) {
            try {
                File file = new File(url.toURI());
                IPath location = Path.fromOSString((String)file.getAbsolutePath());
                ifile = workspace.getRoot().getFileForLocation(location);
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        return ifile;
    }

    public static IFile getIFile(String filePath, String fileName) {
        return ResourceHelpers.getIFile(String.valueOf(filePath) + "/" + fileName);
    }

    public static IFolder getIFolder(String folderPath) {
        String cleanPath = ResourceHelpers.cleanIfNecessaryPath(folderPath);
        Path path = new Path(cleanPath);
        try {
            return root.getFolder((IPath)path);
        }
        catch (IllegalArgumentException exception) {
            return null;
        }
    }

    public static IFolder getIFolder(String folderPath, String folderName) {
        return ResourceHelpers.getIFolder(String.valueOf(folderPath) + "/" + folderName);
    }

    public static IProject getIProject(String projectName) {
        return root.getProject(projectName);
    }

    public static String getFileExtension(String filePath) {
        IFile file = ResourceHelpers.getIFile(filePath);
        return file.getFileExtension();
    }

    public static URL IResourceToURL(IResource resource) throws MalformedURLException {
        URI locationURI = resource.getLocationURI();
        return locationURI.toURL();
    }

    public static String getProperty(IResource resource, String qualifiedProperyName) throws PropertyNotFoundException {
        int index = qualifiedProperyName.lastIndexOf(".");
        String qualifer = qualifiedProperyName.substring(0, index);
        String localName = qualifiedProperyName.substring(index + 1);
        QualifiedName key = new QualifiedName(qualifer, localName);
        String result = "";
        try {
            result = resource.getPersistentProperty(key);
            if (result == null) {
                throw new PropertyNotFoundException(resource, qualifiedProperyName);
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        return result;
    }

    public static void setProperty(IResource resource, String qualifiedProperyName, boolean value) {
        int index = qualifiedProperyName.lastIndexOf(".");
        String qualifer = qualifiedProperyName.substring(0, index);
        String localName = qualifiedProperyName.substring(index + 1);
        QualifiedName key = new QualifiedName(qualifer, localName);
        try {
            resource.setPersistentProperty(key, String.valueOf(value));
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public static void setPropertyRecursively(IResource resource, final String qualifiedName, final boolean value) {
        IResourceVisitor visitor = new IResourceVisitor(){

            public boolean visit(IResource resource) throws CoreException {
                boolean result = false;
                switch (resource.getType()) {
                    case 1: {
                        ResourceHelpers.setProperty(resource, qualifiedName, value);
                        break;
                    }
                    case 2: {
                        result = true;
                        ResourceHelpers.setProperty(resource, qualifiedName, value);
                        break;
                    }
                    case 4: {
                        result = true;
                        ResourceHelpers.setProperty(resource, qualifiedName, value);
                    }
                }
                return result;
            }
        };
        try {
            resource.accept(visitor);
        }
        catch (CoreException coreException) {
            // empty catch block
        }
    }

    public static void setPropertyRecursively(IResource resource, final Hashtable<String, Boolean> qualifiedNames) {
        IResourceVisitor visitor = new IResourceVisitor(){

            public boolean visit(IResource resource) throws CoreException {
                boolean result = false;
                switch (resource.getType()) {
                    case 1: {
                        for (String s : qualifiedNames.keySet()) {
                            ResourceHelpers.setProperty(resource, s, (Boolean)qualifiedNames.get(s));
                        }
                        break;
                    }
                    case 2: {
                        result = true;
                        for (String s : qualifiedNames.keySet()) {
                            ResourceHelpers.setProperty(resource, s, (Boolean)qualifiedNames.get(s));
                        }
                        break;
                    }
                    case 4: {
                        result = true;
                        for (String s : qualifiedNames.keySet()) {
                            ResourceHelpers.setProperty(resource, s, (Boolean)qualifiedNames.get(s));
                        }
                        break;
                    }
                }
                return result;
            }
        };
        try {
            resource.accept(visitor);
        }
        catch (CoreException coreException) {
            // empty catch block
        }
    }

    public static void deleteIProject(String projectName, boolean force) {
        try {
            if (ResourceHelpers.getIProject(projectName) != null) {
                ResourceHelpers.getIProject(projectName).delete(true, force, (IProgressMonitor)new NullProgressMonitor());
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }
}

