/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.aoste.timesquare.ccslkernel.solver.priorities;

import fr.inria.aoste.timesquare.ccslkernel.runtime.elements.RuntimeClock;
import fr.inria.aoste.timesquare.ccslkernel.solver.CCSLKernelSolver;
import fr.inria.aoste.timesquare.ccslkernel.solver.ImplicitClock;
import fr.inria.aoste.timesquare.ccslkernel.solver.priorities.PriorityPropagator;
import fr.inria.aoste.timesquare.ccslkernel.solver.priorities.SolverPrioritySpecification;
import java.util.HashSet;
import java.util.Set;
import java.util.Vector;
import net.sf.javabdd.BuDDyFactory;

public class PrioritySolver {
    private static BuDDyFactory _factory;
    static Vector<String> dico;
    private SolverPrioritySpecification _prioSpec;
    private PriorityPropagator _pp;

    public PrioritySolver(BuDDyFactory factory, SolverPrioritySpecification prioritySpec, CCSLKernelSolver solver) {
        _factory = factory;
        this._prioSpec = prioritySpec;
        this._pp = new PriorityPropagator(this._prioSpec, solver);
    }

    private Set<RuntimeClock> enabled(BuDDyFactory.BuDDyBDD buDDyBDD, Set<RuntimeClock> usedClocks) {
        HashSet<RuntimeClock> eSet = new HashSet<RuntimeClock>();
        for (RuntimeClock c : usedClocks) {
            if (!(!buDDyBDD.and(_factory.ithVar(c.bddVariableNumber)).isZero() & !buDDyBDD.and(_factory.nithVar(c.bddVariableNumber)).isZero())) continue;
            eSet.add(c);
        }
        return eSet;
    }

    public void propagatePriority() {
        this._pp.addPriorityRelationsToSpec();
        this._prioSpec = this._pp.getPrioSpec();
    }

    public BuDDyFactory.BuDDyBDD ResolvePrio(BuDDyFactory.BuDDyBDD buDDyBDD, Set<RuntimeClock> usedClocks) {
        Set<RuntimeClock> eSet = this.enabled(buDDyBDD, usedClocks);
        HashSet<RuntimeClock> temp_eSet = new HashSet<RuntimeClock>(eSet);
        for (RuntimeClock rc : temp_eSet) {
            if (!(rc instanceof ImplicitClock)) continue;
            eSet.remove(rc);
        }
        temp_eSet = null;
        Set<RuntimeClock> fSet = this._prioSpec.removeLowerPrio(eSet);
        if (eSet.size() != fSet.size()) {
            BuDDyFactory.BuDDyBDD res = _factory.zero();
            for (RuntimeClock sc : fSet) {
                BuDDyFactory.BuDDyBDD bdd_sc = buDDyBDD.and(_factory.ithVar(sc.bddVariableNumber));
                HashSet<RuntimeClock> eSetIt = new HashSet<RuntimeClock>(eSet);
                eSetIt.remove(sc);
                BuDDyFactory.BuDDyBDD temp = _factory.ithVar(sc.bddVariableNumber).and(this.ResolvePrio(bdd_sc, eSetIt));
                res = res.or(temp);
                BuDDyFactory.BuDDyBDD bdd_sc_eNot = buDDyBDD.and(_factory.one());
                for (RuntimeClock sc2 : eSet) {
                    bdd_sc_eNot = bdd_sc_eNot.and(_factory.nithVar(sc2.bddVariableNumber));
                }
                if (!(bdd_sc_eNot.satCount() >= 1.0)) continue;
                res = res.or(bdd_sc_eNot);
            }
            return res;
        }
        return _factory.one();
    }
}

