/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.aoste.timesquare.backend.vcdgenerator.behaviors;

import fr.inria.aoste.timesquare.backend.manager.visible.ClockEntity;
import fr.inria.aoste.timesquare.backend.manager.visible.TraceHelper;
import fr.inria.aoste.timesquare.backend.vcdgenerator.behaviors.DurationClockBehavior;
import fr.inria.aoste.timesquare.trace.util.ReferenceNameBuilder;
import fr.inria.aoste.timesquare.vcd.model.BinaryVectorValueChange;
import fr.inria.aoste.timesquare.vcd.model.ICommentCommand;
import fr.inria.aoste.timesquare.vcd.model.ValueChange;
import fr.inria.aoste.timesquare.vcd.model.keyword.VarType;
import fr.inria.aoste.trace.EventOccurrence;
import fr.inria.aoste.trace.FiredStateKind;
import fr.inria.aoste.trace.ModelElementReference;
import java.util.HashMap;

public class TimerClockBehavior
extends DurationClockBehavior {
    private static HashMap<TimerClockBehavior, Boolean> activeBehaviors = new HashMap();
    private static HashMap<TimerClockBehavior, Integer> remainingDurations = new HashMap();
    private ClockEntity startClock;
    private ClockEntity refClock;
    private int delay;

    public int getDelay() {
        return this.delay;
    }

    public TimerClockBehavior(ClockEntity beginClockEntity, ClockEntity refClockEntity, int delay) {
        this.startClock = beginClockEntity;
        this.refClock = refClockEntity;
        this.delay = delay;
    }

    public void run(TraceHelper helper) {
        EventOccurrence eventOccurrence = helper.getClockState();
        if (eventOccurrence.isIsClockDead()) {
            this._scoreBoard.add((ValueChange)new BinaryVectorValueChange("Z", this._pCode));
            return;
        }
        if (helper.getClockEntity().getName().compareTo(this.refClock.getName()) == 0) {
            Integer currentCount;
            if (eventOccurrence.getFState() == FiredStateKind.TICK && (currentCount = remainingDurations.get(this)) != null) {
                remainingDurations.put(this, currentCount - 1);
                if (remainingDurations.get(this) <= 0) {
                    this._scoreBoard.add((ValueChange)new BinaryVectorValueChange("Z", this._pCode));
                    remainingDurations.put(this, this.getDelay());
                    activeBehaviors.put(this, false);
                }
            }
            return;
        }
        if (helper.getClockEntity().getName().compareTo(this.startClock.getName()) == 0) {
            if (eventOccurrence.getFState() == FiredStateKind.TICK) {
                if (activeBehaviors.get(this) == null) {
                    activeBehaviors.put(this, false);
                }
                if (!activeBehaviors.get(this).booleanValue()) {
                    this._scoreBoard.add((ValueChange)new BinaryVectorValueChange("X", this._pCode));
                    remainingDurations.put(this, this.getDelay());
                    activeBehaviors.put(this, true);
                }
            }
            return;
        }
    }

    public void runWithWrongActivationState(TraceHelper helper) {
    }

    public String getDescription() {
        return String.valueOf(this.startClock.getName()) + "'s ticks are the starting points of " + this.getDelay() + " ticks durations on " + this.refClock.getName() + ".";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (this.getClass() != o.getClass()) {
            return false;
        }
        TimerClockBehavior other = (TimerClockBehavior)o;
        return this.startClock == other.startClock && this.refClock == other.refClock && this.delay == other.delay;
    }

    @Override
    public void initialize() {
        this._scoreBoard.addVar("Timer" + this._pCode, VarType.tri, this._pCode);
        ICommentCommand icc = this._scoreBoard.getVcdModel().createCommentClock("alias", "Timer" + this._pCode);
        if (icc != null) {
            String startName = ReferenceNameBuilder.buildQualifiedName((ModelElementReference)this.startClock.getModelElementReference());
            icc.setString(2, "\"Timer started on " + startName + "\"");
        }
        this.setInitialized(true);
    }

    public ClockEntity getStartClock() {
        return this.startClock;
    }

    public ClockEntity getRefClock() {
        return this.refClock;
    }
}

