/**
 * ---------------------------------------------------------------------------------------------
 * Copyright (c) 2020 Inria and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * --------------------------------------------------------------------------------------------
 */
package org.eclipse.gemoc.protocols.eaop.api.data;

import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xbase.lib.util.ToStringBuilder;

/**
 * Information about a Step.
 */
@SuppressWarnings("all")
public class StepDto {
  private MSEOccurenceDto mseOccurence;
  
  /**
   * ID (typically an URI) of the starting RTD state (ie. before this step)
   */
  private String startingStateID;
  
  /**
   * ID (typically an URI) of the ending RTD state (ie. after this step)
   */
  private String endingStateID;
  
  @Pure
  public MSEOccurenceDto getMseOccurence() {
    return this.mseOccurence;
  }
  
  public void setMseOccurence(final MSEOccurenceDto mseOccurence) {
    this.mseOccurence = mseOccurence;
  }
  
  /**
   * ID (typically an URI) of the starting RTD state (ie. before this step)
   */
  @Pure
  public String getStartingStateID() {
    return this.startingStateID;
  }
  
  /**
   * ID (typically an URI) of the starting RTD state (ie. before this step)
   */
  public void setStartingStateID(final String startingStateID) {
    this.startingStateID = startingStateID;
  }
  
  /**
   * ID (typically an URI) of the ending RTD state (ie. after this step)
   */
  @Pure
  public String getEndingStateID() {
    return this.endingStateID;
  }
  
  /**
   * ID (typically an URI) of the ending RTD state (ie. after this step)
   */
  public void setEndingStateID(final String endingStateID) {
    this.endingStateID = endingStateID;
  }
  
  @Override
  @Pure
  public String toString() {
    ToStringBuilder b = new ToStringBuilder(this);
    b.add("mseOccurence", this.mseOccurence);
    b.add("startingStateID", this.startingStateID);
    b.add("endingStateID", this.endingStateID);
    return b.toString();
  }
  
  @Override
  @Pure
  public boolean equals(final Object obj) {
    if (this == obj)
      return true;
    if (obj == null)
      return false;
    if (getClass() != obj.getClass())
      return false;
    StepDto other = (StepDto) obj;
    if (this.mseOccurence == null) {
      if (other.mseOccurence != null)
        return false;
    } else if (!this.mseOccurence.equals(other.mseOccurence))
      return false;
    if (this.startingStateID == null) {
      if (other.startingStateID != null)
        return false;
    } else if (!this.startingStateID.equals(other.startingStateID))
      return false;
    if (this.endingStateID == null) {
      if (other.endingStateID != null)
        return false;
    } else if (!this.endingStateID.equals(other.endingStateID))
      return false;
    return true;
  }
  
  @Override
  @Pure
  public int hashCode() {
    final int prime = 31;
    int result = 1;
    result = prime * result + ((this.mseOccurence== null) ? 0 : this.mseOccurence.hashCode());
    result = prime * result + ((this.startingStateID== null) ? 0 : this.startingStateID.hashCode());
    return prime * result + ((this.endingStateID== null) ? 0 : this.endingStateID.hashCode());
  }
}
