/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.glsp.server.utils;

import java.io.File;
import java.util.Map;
import java.util.Optional;
import org.eclipse.glsp.server.utils.MapUtil;

public final class ClientOptionsUtil {
    public static final String DIAGRAM_TYPE = "diagramType";
    public static final String SOURCE_URI = "sourceUri";
    public static final String IS_RECONNECTING = "isReconnecting";
    private static final String FILE_PREFIX = "file://";

    private ClientOptionsUtil() {
    }

    public static Optional<String> getSourceUri(Map<String, String> options) {
        return MapUtil.getValue(options, SOURCE_URI);
    }

    public static Optional<String> getDiagramType(Map<String, String> options) {
        return MapUtil.getValue(options, DIAGRAM_TYPE);
    }

    public static Optional<File> getSourceUriAsFile(Map<String, String> options) {
        return MapUtil.getValue(options, SOURCE_URI).map(ClientOptionsUtil::getAsFile);
    }

    public static Boolean isReconnecting(Map<String, String> options) {
        return MapUtil.getBoolValue(options, IS_RECONNECTING);
    }

    public static String adaptUri(String uri) {
        return uri.replace(FILE_PREFIX, "");
    }

    public static File getAsFile(String uri) {
        return new File(ClientOptionsUtil.adaptUri(uri));
    }
}

