/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swtchart.extensions.properties;

import org.eclipse.jface.preference.ColorSelector;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swtchart.ITitle;
import org.eclipse.swtchart.Resources;
import org.eclipse.swtchart.extensions.charts.InteractiveChart;
import org.eclipse.swtchart.extensions.properties.AbstractPage;
import org.eclipse.swtchart.extensions.properties.Messages;

public class ChartPage
extends AbstractPage {
    private ColorSelector backgroundInPlotAreaButton;
    private ColorSelector backgroundButton;
    private Button orientationButton;
    protected Button showTitleButton;
    private Label titleLabel;
    private Text titleText;
    private Label fontSizeLabel;
    private Spinner fontSizeSpinner;
    private Label titleColorLabel;
    private ColorSelector titleColorButton;

    public ChartPage(InteractiveChart chart, String title) {
        super(chart, title);
    }

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        this.addChartPanel(composite);
        this.addTitleGroup(composite);
        this.selectValues();
        return composite;
    }

    private void addChartPanel(Composite parent) {
        Composite panel = new Composite(parent, 0);
        panel.setLayout((Layout)new GridLayout(2, false));
        this.createLabelControl(panel, Messages.getString("BACKGROUND_PLOT_AREA"));
        this.backgroundInPlotAreaButton = this.createColorButtonControl(panel);
        this.createLabelControl(panel, Messages.getString("BACKGROUND"));
        this.backgroundButton = this.createColorButtonControl(panel);
        this.orientationButton = this.createCheckBoxControl(panel, Messages.getString("VERTICAL_ORIENTATION"));
    }

    private void addTitleGroup(Composite parent) {
        Group group = this.createGroupControl(parent, Messages.getString("TITLE"), false);
        this.showTitleButton = this.createCheckBoxControl((Composite)group, Messages.getString("SHOW_TITLE"));
        this.showTitleButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ChartPage.this.setTitleControlsEnable(ChartPage.this.showTitleButton.getSelection());
            }
        });
        this.titleLabel = this.createLabelControl((Composite)group, Messages.getString("TEXT"));
        this.titleText = this.createTextControl((Composite)group);
        this.fontSizeLabel = this.createLabelControl((Composite)group, Messages.getString("FONT_SIZE"));
        this.fontSizeSpinner = this.createSpinnerControl((Composite)group, 8, 30);
        this.titleColorLabel = this.createLabelControl((Composite)group, Messages.getString("COLOR"));
        this.titleColorButton = this.createColorButtonControl((Composite)group);
    }

    private void selectValues() {
        this.backgroundInPlotAreaButton.setColorValue(this.chart.getPlotArea().getBackground().getRGB());
        this.backgroundButton.setColorValue(this.chart.getBackground().getRGB());
        this.orientationButton.setSelection(this.chart.getOrientation() == 512);
        ITitle title = this.chart.getTitle();
        this.showTitleButton.setSelection(title.isVisible());
        this.setTitleControlsEnable(title.isVisible());
        this.titleText.setText(title.getText());
        this.fontSizeSpinner.setSelection(title.getFont().getFontData()[0].getHeight());
        this.titleColorButton.setColorValue(title.getForeground().getRGB());
    }

    protected void setTitleControlsEnable(boolean enabled) {
        this.titleLabel.setEnabled(enabled);
        this.titleText.setEnabled(enabled);
        this.fontSizeLabel.setEnabled(enabled);
        this.fontSizeSpinner.setEnabled(enabled);
        this.titleColorLabel.setEnabled(enabled);
        this.titleColorButton.setEnabled(enabled);
    }

    @Override
    public void apply() {
        Color color = Resources.getColor((RGB)this.backgroundInPlotAreaButton.getColorValue());
        this.chart.getPlotArea().setBackground(color);
        color = Resources.getColor((RGB)this.backgroundButton.getColorValue());
        this.chart.setBackground(color);
        this.chart.setOrientation(this.orientationButton.getSelection() ? 512 : 256);
        ITitle title = this.chart.getTitle();
        title.setVisible(this.showTitleButton.getSelection());
        title.setText(this.titleText.getText());
        FontData fontData = title.getFont().getFontData()[0];
        fontData.setHeight(this.fontSizeSpinner.getSelection());
        Font font = Resources.getFont((FontData)fontData);
        title.setFont(font);
        color = Resources.getColor((RGB)this.titleColorButton.getColorValue());
        title.setForeground(color);
    }

    protected void performDefaults() {
        this.backgroundInPlotAreaButton.setColorValue(new RGB(255, 255, 255));
        this.backgroundButton.setColorValue(Display.getDefault().getSystemColor(22).getRGB());
        this.orientationButton.setSelection(false);
        this.showTitleButton.setSelection(true);
        this.setTitleControlsEnable(true);
        this.titleText.setText(Messages.getString("CHART_TITLE"));
        this.fontSizeSpinner.setSelection(13);
        this.titleColorButton.setColorValue(new RGB(0, 0, 255));
        super.performDefaults();
    }
}

