/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.docker.ui.commands;

import java.util.List;
import org.eclipse.linuxtools.docker.core.DockerException;
import org.eclipse.linuxtools.docker.core.IDockerConnection;
import org.eclipse.linuxtools.docker.core.IDockerContainer;
import org.eclipse.linuxtools.internal.docker.ui.commands.BaseContainersCommandHandler;
import org.eclipse.linuxtools.internal.docker.ui.views.DVMessages;

public class StopContainersCommandHandler
extends BaseContainersCommandHandler {
    private static final String CONTAINERS_STOP_MSG = "ContainersStop.msg";
    private static final String CONTAINER_STOP_MSG = "ContainerStop.msg";
    private static final String CONTAINER_STOP_ERROR_MSG = "ContainerStopError.msg";

    @Override
    void executeInJob(IDockerContainer container, IDockerConnection connection) {
        try {
            connection.stopContainer(container.id());
            connection.getContainers(true);
        }
        catch (InterruptedException | DockerException e) {
            String errorMessage = DVMessages.getFormattedString(CONTAINER_STOP_ERROR_MSG, container.id());
            this.openError(errorMessage, (Exception)e);
        }
    }

    @Override
    String getJobName(List<IDockerContainer> selectedContainers) {
        return DVMessages.getString(CONTAINERS_STOP_MSG);
    }

    @Override
    String getTaskName(IDockerContainer container) {
        return DVMessages.getFormattedString(CONTAINER_STOP_MSG, container.name());
    }
}

