/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.project.builder;

import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.m2m.internal.qvt.oml.project.QVTOProjectPlugin;
import org.eclipse.m2m.internal.qvt.oml.project.QvtProjectUtil;
import org.eclipse.m2m.internal.qvt.oml.runtime.project.ProjectDependencyTracker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkspaceDependencyTracker
extends ProjectDependencyTracker {
    public Set<IProject> getReferencedProjects(IProject project, boolean recursive) {
        HashSet<IProject> result = new HashSet<IProject>();
        LinkedList<IProject> candidates = new LinkedList<IProject>(Collections.singleton(project));
        while (!candidates.isEmpty()) {
            IProject candidate = (IProject)candidates.poll();
            if (candidate == null || !candidate.isAccessible()) continue;
            try {
                IProject[] referencedProjects;
                IProject[] iProjectArray = referencedProjects = candidate.getReferencedProjects();
                int n = referencedProjects.length;
                int n2 = 0;
                while (n2 < n) {
                    IProject referencedProject = iProjectArray[n2];
                    if (!referencedProject.isOpen() || QvtProjectUtil.isQvtProject(referencedProject)) {
                        boolean alreadyProcessed;
                        boolean bl = alreadyProcessed = referencedProject == project || !result.add(referencedProject);
                        if (recursive && !alreadyProcessed) {
                            candidates.offer(referencedProject);
                        }
                    }
                    ++n2;
                }
            }
            catch (CoreException e) {
                QVTOProjectPlugin.log(e.getStatus());
            }
        }
        return result;
    }
}

