/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.query.examples.ocl.actions;

import java.util.Collection;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.query.examples.ocl.actions.AbstractQueryDelegate;
import org.eclipse.emf.query.examples.ocl.internal.l10n.QueryOCLMessages;
import org.eclipse.emf.query.examples.ocl.wizards.QueryWithContextWizard;
import org.eclipse.emf.query.ocl.conditions.BooleanOCLCondition;
import org.eclipse.emf.query.statements.FROM;
import org.eclipse.emf.query.statements.IQueryResult;
import org.eclipse.emf.query.statements.SELECT;
import org.eclipse.emf.query.statements.WHERE;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OCLQueryDelegate
extends AbstractQueryDelegate {
    private static String TITLE = QueryOCLMessages.oclQuery_title;
    private static String NOT_FOUND = QueryOCLMessages.oclQuery_message_notFound;
    private BooleanOCLCondition<EClassifier, EClass, EObject> condition;

    public void run(IAction action) {
        Collection<EObject> selection = this.getSelectedObjects();
        if (selection == null || selection.isEmpty()) {
            action.setEnabled(false);
            return;
        }
        QueryWithContextWizard wizard = new QueryWithContextWizard();
        WizardDialog dlg = new WizardDialog(this.getShell(), (IWizard)wizard);
        dlg.setTitle(TITLE);
        dlg.open();
        this.condition = wizard.getCondition();
        if (this.condition != null) {
            try {
                IQueryResult result = this.performQuery(this.getSelectedObjects(), null, (IProgressMonitor)new NullProgressMonitor());
                if (result.isEmpty()) {
                    MessageDialog.openInformation((Shell)this.getShell(), (String)TITLE, (String)NOT_FOUND);
                } else {
                    this.selectInEditor((Collection<?>)result);
                }
            }
            catch (Exception e) {
                MessageDialog.openInformation((Shell)this.getShell(), (String)TITLE, (String)QueryOCLMessages.message_exception);
                throw new RuntimeException(e);
            }
        }
    }

    protected IQueryResult performQuery(Collection<EObject> context, String value, IProgressMonitor monitor) throws Exception {
        if (context == null) {
            throw new NullPointerException("Argument 'context' is null");
        }
        SELECT statement = new SELECT(0, false, new FROM(context), new WHERE(this.condition), monitor);
        this.condition = null;
        return statement.execute();
    }
}

