/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfindex.internal;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.emfindex.store.IndexUpdater;
import org.eclipse.emf.emfindex.store.ResourceIndexer;
import org.eclipse.emf.emfindex.store.ResourceIndexerRegistryImpl;

public class ResourceIndexerRegistryEquinoxImpl
extends ResourceIndexerRegistryImpl {
    public static final String EXTENSION_POINT_ID = "org.eclipse.emf.emfindex.resourceIndexer";
    public static final String CLASS_ATTRIBUTE_NAME = "class";
    public static final String FILE_EXTENSION_ATTRIBUTE_NAME = "fileExtension";

    public ResourceIndexerRegistryEquinoxImpl() {
        IConfigurationElement[] configurationElementsFor;
        IConfigurationElement[] iConfigurationElementArray = configurationElementsFor = Platform.getExtensionRegistry().getConfigurationElementsFor(EXTENSION_POINT_ID);
        int n = configurationElementsFor.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement configurationElement = iConfigurationElementArray[n2];
            String fileExtension = configurationElement.getAttribute(FILE_EXTENSION_ATTRIBUTE_NAME);
            this.addResourceIndexer(fileExtension, new LazyDelegatingResourceIndexer(configurationElement));
            ++n2;
        }
    }

    private static class LazyDelegatingResourceIndexer
    implements ResourceIndexer {
        private final IConfigurationElement configurationElement;
        private ResourceIndexer indexer = null;

        public LazyDelegatingResourceIndexer(IConfigurationElement configurationElement) {
            this.configurationElement = configurationElement;
        }

        protected synchronized ResourceIndexer getIndexer() {
            if (this.indexer == null) {
                this.indexer = this.createIndexer();
            }
            return this.indexer;
        }

        public void resourceChanged(URI resourceURI, IndexUpdater updater) {
            this.getIndexer().resourceChanged(resourceURI, updater);
        }

        public void resourceDeleted(URI resourceURI, IndexUpdater updater) {
            this.getIndexer().resourceDeleted(resourceURI, updater);
        }

        protected ResourceIndexer createIndexer() {
            try {
                return (ResourceIndexer)this.configurationElement.createExecutableExtension(ResourceIndexerRegistryEquinoxImpl.CLASS_ATTRIBUTE_NAME);
            }
            catch (CoreException e) {
                throw new WrappedException((Exception)((Object)e));
            }
        }
    }
}

