/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfindex.query;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import java.util.Iterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.emfindex.EReferenceDescriptor;
import org.eclipse.emf.emfindex.MemoryIndexImpl;
import org.eclipse.emf.emfindex.ResourceDescriptor;
import org.eclipse.emf.emfindex.URI2ResourceCache;
import org.eclipse.emf.emfindex.query.AbstractBaseQueryExecutorStrategy;
import org.eclipse.emf.emfindex.query.EReferenceDescriptorQuery;
import org.eclipse.emf.emfindex.query.LazyQueryResultImpl;
import org.eclipse.emf.emfindex.query.Query;
import org.eclipse.emf.emfindex.query.QueryResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EReferenceQueryExecutorStrategyImpl
extends AbstractBaseQueryExecutorStrategy<EReferenceDescriptor, EReferenceDescriptorQuery, MemoryIndexImpl> {
    @Override
    public boolean canExecute(EReferenceDescriptorQuery query, MemoryIndexImpl index) {
        return true;
    }

    @Override
    public QueryResult<EReferenceDescriptor> execute(final EReferenceDescriptorQuery query, final MemoryIndexImpl index) {
        return new LazyQueryResultImpl<EReferenceDescriptor>(new Iterable<EReferenceDescriptor>(){

            @Override
            public Iterator<EReferenceDescriptor> iterator() {
                return EReferenceQueryExecutorStrategyImpl.this.getResult(query, index);
            }
        });
    }

    public Iterator<EReferenceDescriptor> getResult(final EReferenceDescriptorQuery query, final MemoryIndexImpl index) {
        Iterator<EReferenceDescriptor> sourceScope = this.getSourceResourceScope(query.getSourceResourceQuery(), index);
        if (query.getTargetResourceQuery() != null) {
            final QueryResult targetResourceQueryResult = index.getQueryExecutor().execute(query.getTargetResourceQuery());
            return Iterators.filter(sourceScope, (Predicate)new Predicate<EReferenceDescriptor>(){

                public boolean apply(EReferenceDescriptor candidate) {
                    URI candidateTargetResourceURI = candidate.getTargetFragmentURI().trimFragment();
                    ResourceDescriptor findResourceDescriptor = index.findIndexAdapter(URI2ResourceCache.class).findResourceDescriptor(candidateTargetResourceURI);
                    return Iterables.contains((Iterable)targetResourceQueryResult, (Object)findResourceDescriptor) && EReferenceQueryExecutorStrategyImpl.this.match(query, candidate);
                }
            });
        }
        return Iterators.filter(sourceScope, (Predicate)new Predicate<EReferenceDescriptor>(){

            public boolean apply(EReferenceDescriptor candidate) {
                return EReferenceQueryExecutorStrategyImpl.this.match(query, candidate);
            }
        });
    }

    private Iterator<EReferenceDescriptor> getSourceResourceScope(Query<ResourceDescriptor> sourceResourceQuery, MemoryIndexImpl index) {
        if (sourceResourceQuery != null) {
            Iterator resourceDescriptors = index.getQueryExecutor().execute(sourceResourceQuery).iterator();
            Iterator scope = null;
            while (resourceDescriptors.hasNext()) {
                ResourceDescriptor resourceDescriptor = (ResourceDescriptor)resourceDescriptors.next();
                Iterator eReferencesInResource = resourceDescriptor.getEReferenceDescriptors().iterator();
                Iterator iterator = scope = scope == null ? eReferencesInResource : Iterators.concat(scope, eReferencesInResource);
            }
            if (scope == null) {
                return Iterators.emptyIterator();
            }
            return scope;
        }
        return index.allEReferenceDescriptors();
    }

    @Override
    protected boolean internalMatch(EReferenceDescriptorQuery query, EReferenceDescriptor candidate) {
        boolean result;
        boolean bl = result = query.getTargetResourceURIEquals() == null || query.getTargetResourceURIEquals().equals((Object)candidate.getTargetResourceURI());
        return !(!result || query.getEReferenceEquals() != null && !query.getEReferenceEquals().equals(candidate.getEReference()) || query.getSourceFragmentEquals() != null && !query.getSourceFragmentEquals().equals(candidate.getSourceFragment()) || query.getTargetFragmentEquals() != null && !query.getTargetFragmentEquals().equals(candidate.getTargetFragment()));
    }
}

