/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.xpand.parser;

import java.util.List;
import lpg.lpgjavaruntime.IToken;
import org.eclipse.gmf.internal.xpand.ast.Advice;
import org.eclipse.gmf.internal.xpand.ast.Definition;
import org.eclipse.gmf.internal.xpand.ast.ErrorStatement;
import org.eclipse.gmf.internal.xpand.ast.ExpandStatement;
import org.eclipse.gmf.internal.xpand.ast.ExpressionStatement;
import org.eclipse.gmf.internal.xpand.ast.FileStatement;
import org.eclipse.gmf.internal.xpand.ast.ForEachStatement;
import org.eclipse.gmf.internal.xpand.ast.IfStatement;
import org.eclipse.gmf.internal.xpand.ast.ImportDeclaration;
import org.eclipse.gmf.internal.xpand.ast.LetStatement;
import org.eclipse.gmf.internal.xpand.ast.NamespaceImport;
import org.eclipse.gmf.internal.xpand.ast.ProtectStatement;
import org.eclipse.gmf.internal.xpand.ast.Statement;
import org.eclipse.gmf.internal.xpand.ast.Template;
import org.eclipse.gmf.internal.xpand.ast.TextStatement;
import org.eclipse.gmf.internal.xpand.expression.ast.DeclaredParameter;
import org.eclipse.gmf.internal.xpand.expression.ast.Expression;
import org.eclipse.gmf.internal.xpand.expression.ast.Identifier;
import org.eclipse.gmf.internal.xpand.expression.ast.StringLiteral;
import org.eclipse.gmf.internal.xpand.expression.ast.SyntaxElement;
import org.eclipse.gmf.internal.xpand.expression.parser.ExpressionFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XpandFactory
extends ExpressionFactory {
    public XpandFactory(String fileName) {
        super(fileName);
    }

    public Template createTemplate(List<NamespaceImport> imports, List<ImportDeclaration> extensions, List<Definition> defines, List<Advice> advices, IToken eof) {
        NamespaceImport[] i = imports.toArray(new NamespaceImport[imports.size()]);
        ImportDeclaration[] ext = extensions.toArray(new ImportDeclaration[extensions.size()]);
        Definition[] d = defines.toArray(new Definition[defines.size()]);
        Advice[] a = advices.toArray(new Advice[advices.size()]);
        Template t = new Template(0, XpandFactory.end(eof), 0, i, ext, d, a);
        return this.handle(t);
    }

    public Definition createDefinition(IToken startToken, IToken endToken, IToken n, List<SyntaxElement> p, Identifier type, List<SyntaxElement> s) {
        int start = XpandFactory.start(startToken);
        int end = XpandFactory.end(endToken);
        int line = XpandFactory.line(startToken);
        Identifier name = this.createIdentifier(n);
        DeclaredParameter[] params = p.toArray(new DeclaredParameter[p.size()]);
        Statement[] body = s.toArray(new Statement[s.size()]);
        return this.handle(new Definition(start, end, line, name, type, params, body));
    }

    public TextStatement createTextStatement(IToken t, IToken m) {
        String text = t.toString();
        text = text.length() > 1 ? text.substring(1, text.length() - 1) : "";
        return this.handle(new TextStatement(XpandFactory.start(m != null ? m : t), XpandFactory.end(t), XpandFactory.line(m != null ? m : t), text, m != null));
    }

    public ForEachStatement createForEachStatement(IToken start, IToken end, Expression e, IToken v, Expression sep, IToken iter, List<SyntaxElement> s) {
        Statement[] body = s.toArray(new Statement[s.size()]);
        return this.handle(new ForEachStatement(XpandFactory.start(start), XpandFactory.end(end), XpandFactory.line(start), this.createIdentifier(v), e, body, sep, iter != null ? this.createIdentifier(iter) : null));
    }

    public IfStatement createIfStatement(IToken start, Expression condition, List<SyntaxElement> statements, IfStatement elseIf) {
        Statement[] body = statements.toArray(new Statement[statements.size()]);
        int end = body[body.length - 1].getEnd();
        return this.handle(new IfStatement(XpandFactory.start(start), end, XpandFactory.line(start), condition, body, elseIf));
    }

    public LetStatement createLetStatement(IToken start, IToken end, Expression e, IToken name, List<SyntaxElement> statements) {
        Statement[] body = statements.toArray(new Statement[statements.size()]);
        return this.handle(new LetStatement(XpandFactory.start(start), XpandFactory.end(end), XpandFactory.line(start), this.createIdentifier(name), e, body));
    }

    public ErrorStatement createErrorStatement(IToken start, Expression expr) {
        return this.handle(new ErrorStatement(XpandFactory.start(start), expr.getEnd(), XpandFactory.line(start), expr));
    }

    public ExpressionStatement createExpressionStatement(Expression e) {
        return this.handle(new ExpressionStatement(e.getStart(), e.getEnd(), e.getLine(), e));
    }

    public FileStatement createFileStatement(IToken start, IToken end, Expression fileName, Identifier option, List<SyntaxElement> statements) {
        Statement[] body = statements.toArray(new Statement[statements.size()]);
        return this.handle(new FileStatement(XpandFactory.start(start), XpandFactory.end(end), XpandFactory.line(start), fileName, body, option));
    }

    public ProtectStatement createProtectStatement(IToken start, IToken end, Expression startC, Expression endC, Expression id, IToken disabled, List<SyntaxElement> statements) {
        Statement[] body = statements.toArray(new Statement[statements.size()]);
        return this.handle(new ProtectStatement(XpandFactory.start(start), XpandFactory.end(end), XpandFactory.line(start), startC, endC, body, id, disabled != null));
    }

    public ExpandStatement createExpandStatement(IToken start, Identifier definition, List<Expression> parameters, Expression target, boolean foreach, Expression sep) {
        Expression[] params = parameters.toArray(new Expression[parameters.size()]);
        int end = definition.getEnd();
        if (sep != null) {
            end = sep.getEnd();
        } else if (target != null) {
            end = target.getEnd();
        } else if (params.length > 0) {
            end = params[params.length - 1].getEnd();
        }
        return this.handle(new ExpandStatement(XpandFactory.start(start), end, XpandFactory.line(start), definition, target, sep, params, foreach));
    }

    public NamespaceImport createNamespaceImport(IToken start, StringLiteral namespace) {
        return this.handle(new NamespaceImport(XpandFactory.start(start), namespace.getEnd(), XpandFactory.line(start), namespace));
    }

    public ImportDeclaration createImportDeclaration(IToken start, Identifier namespace) {
        return this.handle(new ImportDeclaration(XpandFactory.start(start), namespace.getEnd(), XpandFactory.line(start), namespace));
    }

    public Advice createAround(IToken start, IToken end, Identifier n, List<SyntaxElement> p, boolean wildparams, Identifier t, List<SyntaxElement> s) {
        DeclaredParameter[] params = p.toArray(new DeclaredParameter[p.size()]);
        Statement[] body = s.toArray(new Statement[s.size()]);
        Advice a = new Advice(XpandFactory.start(start), XpandFactory.end(end), XpandFactory.line(start), n, t, params, wildparams, body);
        return this.handle(a);
    }
}

