/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tests.lite.gen;

import java.text.MessageFormat;
import java.util.Collections;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.codegen.ecore.Generator;
import org.eclipse.gmf.tests.lite.gen.LiteCompilationTest;
import org.eclipse.gmf.tests.setup.DiaGenSource;
import org.eclipse.jdt.core.IBuffer;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.JavaCore;

public class LiteCompilationTestWithImportConflicts
extends LiteCompilationTest {
    public LiteCompilationTestWithImportConflicts(String name) {
        super(name);
    }

    public void testPreexistingImportConflicts() throws Exception {
        DiaGenSource gmfGenSource = this.getLibraryGen(false);
        gmfGenSource.getGenDiagram().getEditorGen().setSameFileForDiagramAndModel(false);
        String pluginId = gmfGenSource.getGenDiagram().getEditorGen().getPlugin().getID();
        IProject diagramProject = ResourcesPlugin.getWorkspace().getRoot().getProject(pluginId);
        if (!diagramProject.isAccessible()) {
            Generator.createEMFProject((IPath)diagramProject.getFolder("src").getFullPath(), null, Collections.emptyList(), (IProgressMonitor)new NullProgressMonitor(), (int)Generator.EMF_PLUGIN_PROJECT_STYLE);
        }
        IJavaProject javaProject = JavaCore.create((IProject)diagramProject);
        LiteCompilationTestWithImportConflicts.assertTrue((boolean)javaProject.exists());
        IPackageFragment pf = javaProject.getPackageFragmentRoot((IResource)diagramProject.getFolder("src")).createPackageFragment(gmfGenSource.getGenDiagram().getNotationViewFactoriesPackageName(), false, (IProgressMonitor)new NullProgressMonitor());
        ICompilationUnit cu = pf.getCompilationUnit(String.valueOf(gmfGenSource.getGenDiagram().getNotationViewFactoryClassName()) + ".java");
        String contents = this.createContents(gmfGenSource.getGenDiagram().getNotationViewFactoriesPackageName(), gmfGenSource.getGenDiagram().getNotationViewFactoryClassName(), "javax.swing.text.View");
        if (cu.exists()) {
            IBuffer buffer = cu.getBuffer();
            buffer.setContents(contents);
            buffer.save((IProgressMonitor)new NullProgressMonitor(), true);
        } else {
            pf.createCompilationUnit(cu.getElementName(), contents, false, (IProgressMonitor)new NullProgressMonitor());
        }
        this.generateAndCompile(gmfGenSource, NO_MUTATORS);
    }

    private String createContents(String packageName, String className, String conflictingImport) {
        return MessageFormat.format("package {0};\nimport {2};\n /**\n * @generated\n */\npublic class {1} '{ }'", packageName, className, conflictingImport);
    }
}

