/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.ui.editparts;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.SnapFeedbackPolicy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ShapeNodeEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.ContainerEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.DecorationEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.GroupComponentEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.GroupXYLayoutEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.NonResizableEditPolicyEx;
import org.eclipse.gmf.runtime.diagram.ui.internal.figures.GroupFigure;
import org.eclipse.gmf.runtime.diagram.ui.requests.ArrangeRequest;
import org.eclipse.gmf.runtime.gef.ui.figures.NodeFigure;
import org.eclipse.gmf.runtime.notation.View;

public class GroupEditPart
extends ShapeNodeEditPart {
    public GroupEditPart(View view) {
        super(view);
    }

    protected NodeFigure createNodeFigure() {
        return new GroupFigure();
    }

    public boolean canAttachNote() {
        return false;
    }

    public IFigure getContentPane() {
        return ((GroupFigure)this.getFigure()).getContainerFigure();
    }

    public void setLayoutConstraint(EditPart child, IFigure childFigure, Object constraint) {
        this.getContentPaneFor((IGraphicalEditPart)child).setConstraint(childFigure, constraint);
    }

    protected void createDefaultEditPolicies() {
        this.installEditPolicy("DecorationPolicy", (EditPolicy)new DecorationEditPolicy());
        this.installEditPolicy("LayoutEditPolicy", (EditPolicy)new GroupXYLayoutEditPolicy());
        this.installEditPolicy("ComponentEditPolicy", (EditPolicy)new GroupComponentEditPolicy());
        this.installEditPolicy("ContainerEditPolicy", (EditPolicy)new GroupContainerEditPolicy());
        this.installEditPolicy("Snap Feedback", (EditPolicy)new SnapFeedbackPolicy());
    }

    public EditPolicy getPrimaryDragEditPolicy() {
        return new NonResizableEditPolicyEx();
    }

    public List getShapeChildren() {
        ArrayList flatChildren = new ArrayList(this.getChildren().size());
        for (Object childEP : this.getChildren()) {
            if (childEP instanceof GroupEditPart) {
                flatChildren.addAll(((GroupEditPart)childEP).getShapeChildren());
                continue;
            }
            flatChildren.add(childEP);
        }
        return flatChildren;
    }

    protected static class GroupContainerEditPolicy
    extends ContainerEditPolicy {
        protected GroupContainerEditPolicy() {
        }

        protected Command getArrangeCommand(ArrangeRequest request) {
            List parts;
            if (("arrangeSelectionAction".equals(request.getType()) || "toolbarArrangeSelectionAction".equals(request.getType())) && (parts = request.getPartsToArrange()).size() == 1 && parts.contains(this.getHost())) {
                ArrangeRequest newRequest = this.createRequest(request, this.getHost().getChildren());
                return super.getArrangeCommand(newRequest);
            }
            return super.getArrangeCommand(request);
        }

        private ArrangeRequest createRequest(ArrangeRequest request, List partsToArrange) {
            ArrangeRequest newRequest = new ArrangeRequest((String)request.getType(), request.getLayoutType());
            newRequest.setExtendedData(request.getExtendedData());
            newRequest.setPartsToArrange(partsToArrange);
            return newRequest;
        }
    }
}

