/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.emf.ui.properties.commands;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.ui.views.properties.IPropertySource;

public class RestoreDefaultPropertyValueCommand
extends AbstractTransactionalCommand {
    private boolean valueResetOnUndo = false;
    private final IPropertySource propertySource;
    private final Object propertyId;
    private Object undoValue;

    public RestoreDefaultPropertyValueCommand(TransactionalEditingDomain editingDomain, String label, Object affectedObjects, IPropertySource propertySource, Object propertyId) {
        super(editingDomain, label, affectedObjects instanceof EObject ? RestoreDefaultPropertyValueCommand.getWorkspaceFiles((EObject)((EObject)affectedObjects)) : null);
        this.propertySource = propertySource;
        this.propertyId = propertyId;
    }

    public boolean canRedo() {
        return true;
    }

    public boolean canUndo() {
        return true;
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        CommandResult result;
        this.setValueResetOnUndo(this.getPropertySource().isPropertySet(this.getPropertyId()));
        if (this.isValueResetOnUndo()) {
            this.setUndoValue(this.getPropertySource().getPropertyValue(this.getPropertyId()));
            this.getPropertySource().resetPropertyValue(this.getPropertyId());
            result = CommandResult.newOKCommandResult((Object)this.getPropertySource().getPropertyValue(this.getPropertyId()));
        } else {
            this.undoValue = null;
            result = CommandResult.newOKCommandResult();
        }
        return result;
    }

    protected CommandResult doRedoWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        return this.doExecuteWithResult(progressMonitor, info);
    }

    protected CommandResult doUndoWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        CommandResult result;
        if (this.isValueResetOnUndo()) {
            this.getPropertySource().setPropertyValue(this.getPropertyId(), this.getUndoValue());
            result = CommandResult.newOKCommandResult((Object)this.getUndoValue());
        } else {
            this.getPropertySource().resetPropertyValue(this.getPropertyId());
            result = CommandResult.newOKCommandResult((Object)this.getPropertySource().getPropertyValue(this.getPropertyId()));
        }
        return result;
    }

    protected boolean isValueResetOnUndo() {
        return this.valueResetOnUndo;
    }

    protected void setValueResetOnUndo(boolean b) {
        this.valueResetOnUndo = b;
    }

    protected IPropertySource getPropertySource() {
        return this.propertySource;
    }

    protected Object getPropertyId() {
        return this.propertyId;
    }

    protected Object getUndoValue() {
        return this.undoValue;
    }

    protected void setUndoValue(Object object) {
        this.undoValue = object;
    }
}

