/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.ui.geoshapes.internal.draw2d.figures;

import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gmf.runtime.diagram.ui.geoshapes.internal.draw2d.figures.GeoShapeFigure;
import org.eclipse.gmf.runtime.draw2d.ui.figures.IPolygonAnchorableFigure;
import org.eclipse.swt.graphics.Path;

public abstract class GeoShapePolygonFigure
extends GeoShapeFigure
implements IPolygonAnchorableFigure {
    protected abstract PointList calculatePoints(Rectangle var1);

    public GeoShapePolygonFigure(int width, int height, int spacing) {
        super(width, height, spacing);
    }

    protected void paintFigure(Graphics g) {
        PointList points = this.calculatePoints(this.getWidthSpecificBounds());
        g.pushState();
        this.applyTransparency(g);
        if (!this.isUsingGradient()) {
            g.fillPolygon(points);
        } else {
            this.fillGradient(g, this.getPath(points));
        }
        g.popState();
        g.setLineStyle(this.getLineStyle());
        g.setLineWidth(this.getLineWidth());
        g.drawPolygon(points);
    }

    public PointList getPolygonPoints() {
        return this.calculatePoints(this.getBounds().getCopy());
    }

    protected Rectangle getWidthSpecificBounds() {
        return this.getBounds().getCopy().shrink(this.getLineWidth() / 2, this.getLineWidth() / 2);
    }

    protected Path getPath(PointList points) {
        Path path = new Path(null);
        if (points.size() > 2) {
            Point pt = points.getFirstPoint();
            path.moveTo((float)pt.x, (float)pt.y);
            int index = 1;
            while (index < points.size()) {
                pt = points.getPoint(index);
                path.lineTo((float)pt.x, (float)pt.y);
                ++index;
            }
            path.close();
        }
        return path;
    }
}

