/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.designer.transformation.tracing.barectf.library.transformations;

import java.io.IOException;
import java.util.List;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.papyrus.designer.deployment.tools.Activator;
import org.eclipse.papyrus.designer.transformation.base.utils.TransformationException;
import org.eclipse.papyrus.designer.transformation.core.m2minterfaces.IM2MTrafoCDP;
import org.eclipse.papyrus.designer.transformation.core.transformations.TransformationContext;
import org.eclipse.papyrus.designer.transformation.profile.Transformation.M2MTrafo;
import org.eclipse.papyrus.designer.transformation.tracing.barectf.library.BareCTFCmd;
import org.eclipse.papyrus.designer.transformation.tracing.barectf.library.BareCTFconfig;
import org.eclipse.papyrus.designer.transformation.tracing.barectf.library.InitCTF;
import org.eclipse.papyrus.designer.transformation.tracing.barectf.library.transformations.BareCTFInstrument;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Package;

public class BareCTFConfigInit
implements IM2MTrafoCDP {
    protected static final String SRC_GEN = "src-gen";
    protected static final String CTF = "ctf";

    public void applyTrafo(M2MTrafo trafo, Package deploymentPlan) throws TransformationException {
        try {
            List<Element> elemsToTrace;
            IFolder srcCTF;
            IFolder srcGEN = TransformationContext.current.project.getFolder(SRC_GEN);
            if (!srcGEN.exists()) {
                srcGEN.create(true, true, null);
            }
            if (!(srcCTF = srcGEN.getFolder(CTF)).exists()) {
                srcCTF.create(true, true, null);
            }
            if ((elemsToTrace = BareCTFInstrument.getElementsToTrace()).size() > 0) {
                TransformationContext.current.keepFiles.add(srcCTF.getFullPath().toString());
                BareCTFconfig.writeConfig(srcCTF, elemsToTrace);
                InitCTF.initCode(srcCTF, deploymentPlan);
                BareCTFCmd cmd = new BareCTFCmd();
                cmd.start(srcCTF);
                BareCTFconfig.injectURIs(elemsToTrace);
            }
        }
        catch (IOException | CoreException e) {
            Activator.log.error(e);
        }
    }
}

