/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.moka.fuml.standardlibrary.library.io;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.RegistryFactory;
import org.eclipse.papyrus.moka.fuml.standardlibrary.Activator;
import org.eclipse.papyrus.moka.fuml.standardlibrary.library.io.DefaultFUMLIOConsole;
import org.eclipse.papyrus.moka.fuml.standardlibrary.library.io.IFUMLIOConsole;

public class FUMLIOConsole {
    private static volatile FUMLIOConsole instance = null;
    private IFUMLIOConsole console = null;

    private FUMLIOConsole() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final FUMLIOConsole getInstance() {
        if (instance != null) return instance;
        Class<FUMLIOConsole> clazz = FUMLIOConsole.class;
        synchronized (FUMLIOConsole.class) {
            if (instance != null) return instance;
            instance = new FUMLIOConsole();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public IFUMLIOConsole getConsole() {
        if (this.console == null) {
            this.loadFUMLIOConsole();
            this.console.init();
        }
        return this.console;
    }

    private void loadFUMLIOConsole() {
        String id = "org.eclipse.papyrus.moka.fuml.standardlibrary.fumlioconsole";
        IExtensionRegistry registry = RegistryFactory.getRegistry();
        IConfigurationElement[] elements = registry.getConfigurationElementsFor(id);
        if (elements.length == 0) {
            this.console = new DefaultFUMLIOConsole();
        } else {
            if (elements.length > 1) {
                Activator.getDefault().logger.warn("Only one FUMLIOConsole can be used. First found will be load");
            }
            IConfigurationElement configurationElement = elements[0];
            try {
                Object fumlioconsoleclass = configurationElement.createExecutableExtension("fumlioconsoleClass");
                if (fumlioconsoleclass instanceof IFUMLIOConsole) {
                    this.console = (IFUMLIOConsole)fumlioconsoleclass;
                }
            }
            catch (CoreException e) {
                Activator.getDefault().logger.error("Failed to create class for " + configurationElement, (Throwable)e);
                this.console = new DefaultFUMLIOConsole();
            }
        }
    }
}

