/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.moka.ui.breakpoint.commands;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.papyrus.moka.tracepoint.service.dialogs.TraceActionSelection;
import org.eclipse.papyrus.moka.ui.breakpoint.commands.AbstractTraceAndDebugCommand;
import org.eclipse.swt.widgets.Display;
import org.eclipse.uml2.uml.Element;

public class TracepointPropertiesCommand
extends AbstractTraceAndDebugCommand {
    public TracepointPropertiesCommand(EObject selectedElement) {
        super("Tracepoint properties", TransactionUtil.getEditingDomain((EObject)selectedElement), selectedElement);
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        this.updateResourceAndURI();
        this.selectTraceActions();
        return null;
    }

    protected void selectTraceActions() {
        IMarker marker = this.findMarker("org.eclipse.papyrus.tracepointmarker");
        if (marker != null) {
            TraceActionSelection tad = new TraceActionSelection(Display.getCurrent().getActiveShell(), marker, (Element)this.selectedElement);
            tad.open();
            if (tad.getReturnCode() == 0) {
                Object[] result = tad.getResult();
                String traceAction = (String)result[0];
                String traceMechanism = (String)result[1];
                try {
                    marker.setAttribute("traceAction", (Object)traceAction);
                    marker.setAttribute("traceMechanism", (Object)traceMechanism);
                }
                catch (CoreException coreException) {}
            }
        }
    }

    @Override
    public boolean canExecute() {
        if (this.selectedElement != null) {
            this.updateResourceAndURI();
            IMarker marker = this.findMarker("org.eclipse.papyrus.tracepointmarker");
            if (marker != null) {
                return marker.getAttribute("isTracepoint", false);
            }
        }
        return false;
    }
}

