/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.robotics.assertions.languages.othello;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.papyrus.robotics.assertions.languages.AssertionsHelper;
import org.eclipse.papyrus.robotics.assertions.languages.IExpressionLanguage;
import org.eclipse.papyrus.robotics.assertions.languages.othello.OCRAIntegration;
import org.eclipse.papyrus.robotics.assertions.profile.assertions.Assertion;
import org.eclipse.papyrus.robotics.assertions.profile.assertions.Contract;
import org.eclipse.papyrus.robotics.assertions.ui.actions.ScrollableColorMessageDialog;
import org.eclipse.papyrus.robotics.bpc.profile.bpc.Port;
import org.eclipse.papyrus.robotics.profile.robotics.components.ComponentDefinition;
import org.eclipse.papyrus.robotics.profile.robotics.components.ComponentInstance;
import org.eclipse.papyrus.robotics.profile.robotics.components.ComponentOrSystem;
import org.eclipse.papyrus.robotics.profile.robotics.components.ComponentPort;
import org.eclipse.papyrus.robotics.profile.robotics.components.System;
import org.eclipse.papyrus.robotics.profile.robotics.services.ServiceDefinition;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.uml2.uml.ConnectableElement;
import org.eclipse.uml2.uml.Connector;
import org.eclipse.uml2.uml.ConnectorEnd;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.util.UMLUtil;

public class OthelloLanguage
implements IExpressionLanguage {
    public static final String OSS_EXT = ".oss";
    public static final String P4R_TEMP = "p4r_temp_";
    public static final String NAME = "Othello";

    public String getName() {
        return NAME;
    }

    public Object evaluate(EObject context, String expression) {
        String ocraConsole;
        if (expression != null) {
            expression = this.updateExpression(context, expression);
        }
        String oss = this.getOSSForEvaluation(context, expression);
        String ocra_command = null;
        ocra_command = (context instanceof System || context instanceof Element && UMLUtil.getStereotypeApplication((Element)((Element)context), System.class) != null) && oss.contains(" REFINEDBY ") ? "ocra_check_refinement" : "ocra_check_consistency";
        String ocraPath = Platform.getPreferencesService().getString("org.eclipse.papyrus.robotics.assertions.languages.othello", "OCRA_PATH", "", null);
        if (ocraPath == null || ocraPath.isEmpty()) {
            MessageDialog.openInformation((Shell)Display.getCurrent().getActiveShell(), (String)"Othello language", (String)"OCRA path is not defined in the Eclipse preferences.");
            return null;
        }
        File file = new File(ocraPath);
        if (!file.exists()) {
            MessageDialog.openInformation((Shell)Display.getCurrent().getActiveShell(), (String)"Othello language", (String)"OCRA path in the Eclipse preferences points to a file that does not exist.");
            return null;
        }
        try {
            File tempFile = File.createTempFile(P4R_TEMP, OSS_EXT);
            OCRAIntegration.writeFile(tempFile, oss.toString());
            ocraConsole = OCRAIntegration.getConsoleResult(ocraPath, tempFile.getAbsolutePath(), ocra_command);
            tempFile.delete();
        }
        catch (Exception e) {
            return null;
        }
        ScrollableColorMessageDialog dialog = new ScrollableColorMessageDialog(Display.getCurrent().getActiveShell(), "Using OCRA to evaluate " + this.getName() + " assertions", "OSS file. Command: " + ocra_command, oss.toString());
        dialog.open();
        dialog = new ScrollableColorMessageDialog(Display.getCurrent().getActiveShell(), "Using OCRA to evaluate " + this.getName() + " assertions", "OCRA Console. Command: " + ocra_command, ocraConsole);
        dialog.open();
        if (!ocraConsole.contains("Success: all the contracts are consistent") && !ocraConsole.contains("Summary: everything is OK.")) {
            return false;
        }
        return true;
    }

    public StringBuffer ossFromSystem(System system, boolean addContracts) {
        StringBuffer oss = new StringBuffer();
        oss.append("COMPONENT " + system.getBase_Class().getName() + " system\n");
        oss.append("INTERFACE\n");
        int indexSystemInterface = oss.length();
        oss.append("REFINEMENT\n");
        for (ComponentInstance compInstance : system.getInstances()) {
            ComponentOrSystem compDef = compInstance.getCompdefOrSys();
            oss.append("SUB ");
            oss.append(compInstance.getBase_Property().getName());
            oss.append(":");
            oss.append(compDef.getBase_Class().getName());
            oss.append(";\n");
        }
        for (Connector connector : system.getBase_Class().getOwnedConnectors()) {
            oss.append("CONNECTION ");
            String input = null;
            String output = null;
            block2: for (ConnectorEnd connectorEnd : connector.getEnds()) {
                ConnectableElement ce = connectorEnd.getRole();
                Property prop = connectorEnd.getPartWithPort();
                String portName = String.valueOf(prop.getName()) + "." + ce.getName();
                ComponentInstance compInstance = (ComponentInstance)UMLUtil.getStereotypeApplication((Element)prop, ComponentInstance.class);
                ComponentOrSystem compDef = compInstance.getCompdefOrSys();
                for (Port port : compDef.getPort()) {
                    if (!((ComponentPort)port).getBase_Port().equals(ce)) continue;
                    if (this.isInputPort(port)) {
                        input = portName;
                        continue block2;
                    }
                    output = portName;
                    continue block2;
                }
            }
            oss.append(input);
            oss.append(" := ");
            oss.append(output);
            oss.append(";\n");
        }
        int indexEndOfSystem = oss.length();
        StringBuffer refinedby = new StringBuffer();
        ArrayList<String> alreadyAdded = new ArrayList<String>();
        for (ComponentInstance compInstance : system.getInstances()) {
            StringBuffer contract;
            ComponentOrSystem compDef = compInstance.getCompdefOrSys();
            String compDefName = compDef.getBase_Class().getName();
            if (alreadyAdded.contains(compDefName)) continue;
            oss.append("\n");
            alreadyAdded.add(compDefName);
            oss.append(this.ossFromCompDefinition(compDef, false));
            if (!addContracts || (contract = this.ossFromCompInstanceContract(compInstance)).length() == 0) continue;
            oss.append(contract);
            refinedby.append(String.valueOf(compInstance.getBase_Property().getName()) + ".pass, ");
        }
        if (addContracts && refinedby.length() != 0) {
            refinedby.setLength(refinedby.length() - ", ".length());
            oss.insert(indexEndOfSystem, "CONTRACT pass REFINEDBY " + refinedby + ";\n");
            oss.insert(indexSystemInterface, "CONTRACT pass\nassume: true;\nguarantee: true;\n");
        }
        return oss;
    }

    public StringBuffer ossFromCompInstanceContract(ComponentInstance compInstance) {
        StringBuffer oss = new StringBuffer();
        List contracts = AssertionsHelper.getCompDefinitionContracts((ComponentOrSystem)compInstance.getCompdefOrSys());
        for (Contract contract : contracts) {
            oss.append(this.ossFromContract((EObject)compInstance, contract));
        }
        return oss;
    }

    public StringBuffer ossFromContract(EObject context, Contract contract) {
        StringBuffer oss = new StringBuffer();
        oss.append("CONTRACT pass\n");
        Object assumptions = contract.getAssumptions();
        assumptions = this.getOthelloAssertions((List<Assertion>)assumptions);
        if (assumptions != null && !assumptions.isEmpty()) {
            String assumptionValue = ((Assertion)assumptions.get(0)).getBase_Constraint().getSpecification().stringValue();
            oss.append("assume: " + this.updateExpression(context, assumptionValue) + ";\n");
        } else {
            oss.append("assume: true;\n");
        }
        Object guarantees = contract.getGuarantees();
        guarantees = this.getOthelloAssertions((List<Assertion>)guarantees);
        if (guarantees != null && !guarantees.isEmpty()) {
            String guaranteeValue = ((Assertion)guarantees.get(0)).getBase_Constraint().getSpecification().stringValue();
            oss.append("guarantee: " + this.updateExpression(context, guaranteeValue) + ";\n");
        } else {
            oss.append("guarantee: true;\n");
        }
        return oss;
    }

    public String updateExpression(EObject context, String expression) {
        return expression;
    }

    public StringBuffer ossFromCompDefinition(ComponentOrSystem compDef, boolean considerAsSystem) {
        StringBuffer oss = new StringBuffer();
        oss.append("COMPONENT " + compDef.getBase_Class().getName());
        if (considerAsSystem) {
            oss.append(" system\n");
        } else {
            oss.append("\n");
        }
        oss.append("INTERFACE\n");
        for (Port port : compDef.getPort()) {
            ComponentPort compPort = (ComponentPort)port;
            boolean input = this.isInputPort(port);
            if (input) {
                oss.append("INPUT PORT ");
            } else {
                oss.append("OUTPUT PORT ");
            }
            String name = compPort.getBase_Port().getName();
            String type = null;
            if (compPort.isCoordinationPort()) {
                type = "event";
            } else {
                String nameService;
                ServiceDefinition serviceDefinition = compPort.getProvides();
                if (serviceDefinition == null) {
                    serviceDefinition = compPort.getRequires();
                }
                type = (nameService = serviceDefinition.getBase_Interface().getName()).toLowerCase().contains("bool") ? "boolean" : (nameService.toLowerCase().contains("real") ? "real" : (nameService.toLowerCase().contains("int") ? "integer" : "event"));
            }
            oss.append(String.valueOf(name) + ": " + type + ";\n");
        }
        return oss;
    }

    public List<Assertion> getOthelloAssertions(List<Assertion> assertions) {
        ArrayList<Assertion> othello = new ArrayList<Assertion>();
        for (Assertion assertion : assertions) {
            String name = AssertionsHelper.getAssertionLanguage((Assertion)assertion);
            if (name == null || !name.equals(this.getName())) continue;
            othello.add(assertion);
        }
        return othello;
    }

    public boolean isGlobalEvaluation() {
        return true;
    }

    public String getOSSForEvaluation(EObject context, String expression) {
        StringBuffer oss;
        block19: {
            ComponentDefinition compDefinition;
            block21: {
                ComponentInstance compInstance;
                block20: {
                    compDefinition = null;
                    compInstance = null;
                    System system = null;
                    if (context instanceof ComponentDefinition) {
                        compDefinition = (ComponentDefinition)context;
                    } else if (context instanceof Element && UMLUtil.getStereotypeApplication((Element)((Element)context), ComponentDefinition.class) != null) {
                        compDefinition = (ComponentDefinition)UMLUtil.getStereotypeApplication((Element)((Element)context), ComponentDefinition.class);
                    }
                    if (compDefinition == null) {
                        if (context instanceof ComponentInstance) {
                            compInstance = (ComponentInstance)context;
                        } else if (context instanceof Element && UMLUtil.getStereotypeApplication((Element)((Element)context), ComponentInstance.class) != null) {
                            compInstance = (ComponentInstance)UMLUtil.getStereotypeApplication((Element)((Element)context), ComponentInstance.class);
                        }
                    }
                    if (compDefinition == null && compInstance == null) {
                        if (context instanceof System) {
                            system = (System)context;
                        } else if (context instanceof Element && UMLUtil.getStereotypeApplication((Element)((Element)context), System.class) != null) {
                            system = (System)UMLUtil.getStereotypeApplication((Element)((Element)context), System.class);
                        }
                    }
                    oss = new StringBuffer();
                    if (expression != null) {
                        if (system != null) {
                            oss = this.ossFromSystem(system, true);
                            int systemRef = oss.indexOf("REFINEMENT");
                            String contract = "CONTRACT pass\nassume: true;\nguarantee: " + expression + ";\n";
                            oss.insert(systemRef, contract);
                        } else if (compInstance != null) {
                            ComponentOrSystem compDef = compInstance.getCompdefOrSys();
                            oss = this.ossFromCompDefinition(compDef, true);
                            oss.append("CONTRACT pass\n");
                            oss.append("assume: true;\n");
                            oss.append("guarantee: " + expression + ";\n");
                        } else if (compDefinition != null) {
                            oss = this.ossFromCompDefinition((ComponentOrSystem)compDefinition, true);
                            oss.append("CONTRACT pass\n");
                            oss.append("assume: true;\n");
                            oss.append("guarantee: " + expression + ";\n");
                        }
                    }
                    if (expression != null) break block19;
                    if (system == null) break block20;
                    oss = this.ossFromSystem(system, true);
                    break block19;
                }
                if (compInstance == null) break block21;
                ComponentOrSystem compDef = compInstance.getCompdefOrSys();
                oss = this.ossFromCompDefinition(compDef, true);
                List contracts = AssertionsHelper.getCompDefinitionContracts((ComponentOrSystem)compDef);
                for (Contract contract : contracts) {
                    oss.append(this.ossFromContract((EObject)compInstance, contract));
                }
                break block19;
            }
            if (compDefinition == null) break block19;
            oss = this.ossFromCompDefinition((ComponentOrSystem)compDefinition, true);
            List contracts = AssertionsHelper.getCompDefinitionContracts((ComponentOrSystem)compDefinition);
            for (String contract : contracts) {
                oss.append(this.ossFromContract((EObject)compDefinition, (Contract)contract));
            }
        }
        return oss.toString();
    }

    public boolean isInputPort(Port port) {
        ComponentPort compPort = (ComponentPort)port;
        if (compPort.isCoordinationPort()) {
            return false;
        }
        boolean input = compPort.getRequires() != null;
        return input;
    }
}

