/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.robotics.ros2.reverse.fromfile;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.core.dom.ast.IASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTFieldReference;
import org.eclipse.cdt.core.dom.ast.IASTFileLocation;
import org.eclipse.cdt.core.dom.ast.IASTFunctionCallExpression;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDefinition;
import org.eclipse.cdt.core.dom.ast.IASTIdExpression;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTTypeId;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.ITypedef;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTNamedTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTNamespaceDefinition;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTemplateId;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.emf.common.util.URI;
import org.eclipse.papyrus.designer.infra.base.StringUtils;
import org.eclipse.papyrus.robotics.ros2.reverse.Activator;
import org.eclipse.papyrus.robotics.ros2.reverse.PortInfo;
import org.eclipse.papyrus.robotics.ros2.reverse.utils.CreatePortUtils;
import org.eclipse.papyrus.robotics.ros2.reverse.utils.ServiceDefUtils;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Interface;

public class ReversePortsFromSource {
    private static final String CREATE_PUBLISHER = "create_publisher";
    private static final String CREATE_SUBSCRIPTION = "create_subscription";
    private static final String CREATE_SERVICE = "create_service";
    private static final String CREATE_CLIENT = "create_client";
    private static final String CREATE_ACTION_SRV = "rclcpp_action::create_server";
    private static final String CREATE_ACTION_CLI = "rclcpp_action::create_client";
    protected Class clazz;
    protected List<URI> pathMapURIs;
    protected ITranslationUnit itu;
    List<PortInfo> portInfoList;

    public ReversePortsFromSource(Class clazz, List<URI> pathMapURIs, ITranslationUnit itu) {
        this.clazz = clazz;
        this.pathMapURIs = pathMapURIs;
        this.itu = itu;
        this.portInfoList = new ArrayList<PortInfo>();
    }

    public List<PortInfo> getPortInfoList() {
        return this.portInfoList;
    }

    public void updatePorts(IASTNode node) {
        this.scanFunctions(node);
        for (PortInfo pi : this.portInfoList) {
            String sdName;
            String pkgName;
            String[] nameArray = pi.dtQName.split("::");
            if (nameArray.length > 2) {
                pkgName = nameArray[0];
                sdName = nameArray[2];
            } else {
                pkgName = "*";
                sdName = pi.dtQName;
            }
            Interface sd = ServiceDefUtils.getServiceDef(this.clazz, this.pathMapURIs, pi.pk, pkgName, sdName);
            if (sd != null) {
                CreatePortUtils.createPort(this.clazz, pi, sd);
                continue;
            }
            Activator.log.debug(String.format("Cannot find service <%s>", pi.dtQName));
        }
    }

    public void scanFunctions(IASTNode node) {
        IASTNode[] iASTNodeArray = node.getChildren();
        int n = iASTNodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IASTNode child = iASTNodeArray[n2];
            if (child instanceof IASTFunctionDefinition) {
                IASTFunctionDefinition definition = (IASTFunctionDefinition)child;
                this.scanBody((IASTNode)definition.getBody());
            }
            if (child instanceof ICPPASTNamespaceDefinition) {
                this.scanFunctions(child);
            }
            ++n2;
        }
    }

    public static String getASTName(IASTExpression expr) {
        if (expr instanceof IASTFieldReference) {
            IASTName fieldName = ((IASTFieldReference)expr).getFieldName();
            if (fieldName != null) {
                return fieldName.toString();
            }
            return "";
        }
        return expr.toString();
    }

    public static PortInfo.PortKind getProviderFromCall(String fctName) {
        if (fctName.equals(CREATE_CLIENT)) {
            return PortInfo.PortKind.CLIENT;
        }
        if (fctName.equals(CREATE_SERVICE)) {
            return PortInfo.PortKind.SERVER;
        }
        if (fctName.equals(CREATE_SUBSCRIPTION)) {
            return PortInfo.PortKind.SUBSCRIBER;
        }
        if (fctName.equals(CREATE_PUBLISHER)) {
            return PortInfo.PortKind.PUBLISHER;
        }
        if (fctName.equals(CREATE_ACTION_SRV)) {
            return PortInfo.PortKind.ACTION_SRV;
        }
        if (fctName.equals(CREATE_ACTION_CLI)) {
            return PortInfo.PortKind.ACTION_CLI;
        }
        return null;
    }

    public PortInfo obtainCallDetails(PortInfo.PortKind pk, IASTFunctionCallExpression fCallExpr, ICPPASTTemplateId templateId) {
        if (fCallExpr.getArguments().length >= 2) {
            String topicName = fCallExpr.getArguments()[0].toString();
            IASTFileLocation qosLoc = fCallExpr.getArguments()[1].getFileLocation();
            char[] contents = this.itu.getContents();
            String qos = new String(contents, qosLoc.getNodeOffset(), qosLoc.getNodeLength());
            PortInfo portInfo = new PortInfo();
            portInfo.pk = pk;
            IASTNode argument = templateId.getTemplateArguments()[0];
            if (argument instanceof IASTTypeId) {
                IBinding binding;
                IASTDeclSpecifier declSpecifier = ((IASTTypeId)argument).getDeclSpecifier();
                if (declSpecifier instanceof ICPPASTNamedTypeSpecifier && (binding = ((ICPPASTNamedTypeSpecifier)declSpecifier).getName().resolveBinding()) != null && !(binding instanceof ITypedef)) {
                    portInfo.dtQName = binding.toString();
                }
                if (portInfo.dtQName == null) {
                    portInfo.dtQName = ((IASTTypeId)argument).getDeclSpecifier().toString();
                }
            } else {
                Activator.log.debug("Unexpected template argument");
            }
            portInfo.topic = StringUtils.unquote((String)topicName.trim());
            portInfo.qos = qos.trim();
            return portInfo;
        }
        return null;
    }

    public void scanBody(IASTNode node) {
        PortInfo portInfo;
        ICPPASTTemplateId templateId;
        String fctName;
        PortInfo.PortKind pk;
        IASTIdExpression nameId;
        IASTName astName;
        IASTFunctionCallExpression fCallExpr;
        IASTExpression nameExpr;
        if (node instanceof IASTFunctionCallExpression && (nameExpr = (fCallExpr = (IASTFunctionCallExpression)node).getFunctionNameExpression()) instanceof IASTIdExpression && (astName = (nameId = (IASTIdExpression)nameExpr).getName()) instanceof ICPPASTTemplateId && (pk = ReversePortsFromSource.getProviderFromCall(fctName = (templateId = (ICPPASTTemplateId)astName).getTemplateName().toString())) != null && (portInfo = this.obtainCallDetails(pk, fCallExpr, templateId)) != null) {
            this.portInfoList.add(portInfo);
        }
        IASTNode[] iASTNodeArray = node.getChildren();
        int n = iASTNodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IASTNode child = iASTNodeArray[n2];
            this.scanBody(child);
            ++n2;
        }
    }
}

