/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.sort;

import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.nebula.widgets.nattable.sort.SortDirectionEnum;
import org.eclipse.papyrus.infra.nattable.manager.table.INattableModelManager;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxis.IAxis;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattablestyle.NattablestylePackage;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattablestyle.StringValueStyle;
import org.eclipse.papyrus.infra.nattable.sort.copy.NatTableComparatorChooser;

public class ColumnSortUtils {
    private static final String SEPARATOR = "_";

    private ColumnSortUtils() {
    }

    public static final String buildSortStringValue(NatTableComparatorChooser<?> chooser, int columnIndex) {
        int clickSequence = chooser.getClickSequence(columnIndex);
        SortDirectionEnum direction = chooser.getSortDirectionForColumnIndex(columnIndex);
        StringBuilder builder = new StringBuilder();
        builder.append(clickSequence);
        builder.append(SEPARATOR);
        builder.append(direction.toString());
        return builder.toString();
    }

    public static final String buildComparatorValues(INattableModelManager manager) {
        TreeMap<StringValueStyle, IAxis> sortedAxis = new TreeMap<StringValueStyle, IAxis>(new SortComparator());
        for (Object current : manager.getColumnElementsList()) {
            StringValueStyle style;
            if (!(current instanceof IAxis) || (style = (StringValueStyle)((IAxis)current).getNamedStyle(NattablestylePackage.eINSTANCE.getStringValueStyle(), "sort")) == null) continue;
            sortedAxis.put(style, (IAxis)current);
        }
        StringBuilder builder = new StringBuilder();
        Iterator iter = sortedAxis.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry current = iter.next();
            int colIndex = manager.getColumnElementsList().indexOf(current.getValue());
            SortDirectionEnum direction = SortDirectionEnum.valueOf((String)((StringValueStyle)current.getKey()).getStringValue().split(SEPARATOR)[1]);
            builder.append("column ");
            builder.append(colIndex);
            if (SortDirectionEnum.DESC.equals((Object)direction)) {
                builder.append(" reversed");
            }
            if (!iter.hasNext()) continue;
            builder.append(", ");
        }
        return builder.toString();
    }

    private static final class SortComparator
    implements Comparator<StringValueStyle> {
        private SortComparator() {
        }

        @Override
        public int compare(StringValueStyle o1, StringValueStyle o2) {
            Integer order1 = Integer.valueOf(o1.getStringValue().split(ColumnSortUtils.SEPARATOR)[0]);
            Integer order2 = Integer.valueOf(o2.getStringValue().split(ColumnSortUtils.SEPARATOR)[0]);
            return order1.compareTo(order2);
        }
    }
}

