/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sirius.properties.uml.services;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.papyrus.sirius.properties.common.utils.SiriusInterpreterHelper;
import org.eclipse.papyrus.sirius.properties.uml.services.PropertiesCrudServices;
import org.eclipse.papyrus.uml.tools.util.MultiplicityParser;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreter;
import org.eclipse.sirius.properties.core.api.SiriusInputDescriptor;
import org.eclipse.uml2.uml.LiteralUnlimitedNatural;
import org.eclipse.uml2.uml.MultiplicityElement;
import org.eclipse.uml2.uml.UMLFactory;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.ValueSpecification;

public class PropertiesMultiplicityServices {
    private static final String LOWER_VALUE_FEATURE_NAME = UMLPackage.eINSTANCE.getMultiplicityElement_LowerValue().getName();
    private static final String UPPER_VALUE_FEATURE_NAME = UMLPackage.eINSTANCE.getMultiplicityElement_UpperValue().getName();
    private static final String LITERAL_UNLIMITED_NATURAL_ECLASSIFIER_NAME = UMLPackage.eINSTANCE.getLiteralUnlimitedNatural().getName();
    private static final String LITERAL_INTEGER_ECLASSIFIER_NAME = UMLPackage.eINSTANCE.getLiteralInteger().getName();
    private static final String VALUE = "value";
    private PropertiesCrudServices propertiesSetterServices = new PropertiesCrudServices();

    public String getMultiplicity(EObject target) {
        String multiplicityStringValue = "";
        if (target instanceof MultiplicityElement) {
            MultiplicityElement multiplicityElement = (MultiplicityElement)target;
            int lower = multiplicityElement.lowerBound();
            int upper = multiplicityElement.upperBound();
            multiplicityStringValue = MultiplicityParser.getMultiplicity((int)lower, (int)upper);
        }
        return multiplicityStringValue;
    }

    public boolean setMultiplicity(MultiplicityElement target, String valueToSet, SiriusInputDescriptor input) {
        boolean isSet = false;
        IInterpreter interpreter = this.getSiriusInterpreter(input);
        if (interpreter != null) {
            SiriusInterpreterHelper.getInstance().clearValidationVariablesFromInterpreter(input);
            interpreter.setVariable("multiplicityValue", (Object)valueToSet);
        }
        if (interpreter != null && this.validateMultiplicityField((EObject)target, input)) {
            this.propertiesSetterServices.delete(target.getLowerValue(), (EObject)target, LOWER_VALUE_FEATURE_NAME);
            this.propertiesSetterServices.delete(target.getUpperValue(), (EObject)target, UPPER_VALUE_FEATURE_NAME);
            int[] bounds = MultiplicityParser.getBounds((String)valueToSet);
            EObject lowerValue = this.propertiesSetterServices.create((EObject)target, LITERAL_INTEGER_ECLASSIFIER_NAME, LOWER_VALUE_FEATURE_NAME);
            EObject upperValue = this.propertiesSetterServices.create((EObject)target, LITERAL_UNLIMITED_NATURAL_ECLASSIFIER_NAME, UPPER_VALUE_FEATURE_NAME);
            boolean lowerSet = this.propertiesSetterServices.set(lowerValue, VALUE, bounds[0]);
            boolean upperSet = this.propertiesSetterServices.set(upperValue, VALUE, bounds[1]);
            isSet = lowerSet && upperSet;
        } else {
            ValueSpecification upperValue = target.getUpperValue();
            if (upperValue != null) {
                EStructuralFeature structuralFeature = upperValue.eClass().getEStructuralFeature(VALUE);
                if (structuralFeature != null) {
                    int oldUpper = target.upperBound();
                    upperValue.eSet(structuralFeature, (Object)0);
                    upperValue.eSet(structuralFeature, (Object)oldUpper);
                }
            } else {
                EClass lUNClass = UMLPackage.eINSTANCE.getLiteralUnlimitedNatural();
                LiteralUnlimitedNatural literalUnlimitedNatural = (LiteralUnlimitedNatural)UMLFactory.eINSTANCE.create(lUNClass);
                target.setUpperValue((ValueSpecification)literalUnlimitedNatural);
                target.setUpperValue(null);
            }
        }
        return isSet;
    }

    public boolean validateMultiplicityField(EObject target, SiriusInputDescriptor input) {
        boolean result = false;
        String newValue = null;
        IInterpreter interpreter = this.getSiriusInterpreter(input);
        newValue = interpreter != null && interpreter.getVariables().containsKey("multiplicityValue") ? (String)interpreter.getVariables().get("multiplicityValue") : this.getMultiplicity(target);
        result = this.checkMultiplicityValue(newValue);
        return result;
    }

    private boolean checkMultiplicityValue(String newValue) {
        boolean result = newValue instanceof String ? MultiplicityParser.isValidMultiplicity((String)newValue) : false;
        return result;
    }

    public String getMultiplicityAsString(SiriusInputDescriptor input) {
        String result = "";
        IInterpreter interpreter = this.getSiriusInterpreter(input);
        if (interpreter != null && interpreter.getVariables().get("multiplicityValue") instanceof String) {
            result = (String)interpreter.getVariables().get("multiplicityValue");
        }
        return result;
    }

    protected IInterpreter getSiriusInterpreter(SiriusInputDescriptor input) {
        return SiriusInterpreterHelper.getInstance().getSiriusInterpreter(input);
    }
}

