/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.constraints.constraints;

import java.util.Collection;
import java.util.List;
import org.eclipse.papyrus.infra.constraints.Activator;
import org.eclipse.papyrus.infra.constraints.ConfigProperty;
import org.eclipse.papyrus.infra.constraints.ConstraintDescriptor;
import org.eclipse.papyrus.infra.constraints.DisplayUnit;
import org.eclipse.papyrus.infra.constraints.ReferenceProperty;
import org.eclipse.papyrus.infra.constraints.SimpleConstraint;
import org.eclipse.papyrus.infra.constraints.ValueProperty;
import org.eclipse.papyrus.infra.constraints.constraints.Constraint;

public abstract class AbstractConstraint
implements Constraint {
    protected ConstraintDescriptor descriptor;
    protected DisplayUnit display;

    @Override
    public final void setConstraintDescriptor(ConstraintDescriptor descriptor) {
        this.descriptor = descriptor;
        this.display = this.getDisplay(descriptor);
        if (descriptor instanceof SimpleConstraint) {
            this.setDescriptor((SimpleConstraint)descriptor);
        }
    }

    private DisplayUnit getDisplay(ConstraintDescriptor descriptor) {
        if (descriptor.getDisplay() == null && descriptor.eContainer() instanceof ConstraintDescriptor) {
            return this.getDisplay((ConstraintDescriptor)descriptor.eContainer());
        }
        return descriptor.getDisplay();
    }

    @Override
    public DisplayUnit getDisplayUnit() {
        return this.display;
    }

    @Override
    public boolean overrides(Constraint constraint) {
        return this.equivalent(constraint) && this.getDisplayUnit().getElementMultiplicity() == 1 && constraint.getDisplayUnit().getElementMultiplicity() != 1;
    }

    protected abstract boolean equivalent(Constraint var1);

    @Override
    public ConstraintDescriptor getDescriptor() {
        return this.descriptor;
    }

    protected ConfigProperty getProperty(String propertyName) {
        if (this.descriptor == null || !(this.descriptor instanceof SimpleConstraint)) {
            Activator.log.warn("The constraint descriptor has not been set for this constraint : " + String.valueOf(this));
        } else {
            for (ConfigProperty property : ((SimpleConstraint)this.descriptor).getProperties()) {
                if (!property.getName().equals(propertyName)) continue;
                return property;
            }
        }
        Activator.log.warn("The property " + propertyName + " has not been set for constraint " + this.descriptor.getName());
        return null;
    }

    protected boolean hasProperty(String propertyName) {
        if (this.descriptor == null || !(this.descriptor instanceof SimpleConstraint)) {
            Activator.log.warn("The constraint descriptor has not been set for this constraint : " + String.valueOf(this));
        } else {
            for (ConfigProperty property : ((SimpleConstraint)this.descriptor).getProperties()) {
                if (!property.getName().equals(propertyName)) continue;
                return true;
            }
        }
        return false;
    }

    protected String getValue(String propertyName) {
        ConfigProperty property = this.getProperty(propertyName);
        if (property instanceof ValueProperty) {
            return ((ValueProperty)property).getValue();
        }
        Activator.log.warn("The property " + propertyName + " is not a ValueProperty (Constraint " + this.descriptor.getName() + ")");
        return null;
    }

    protected Object getReferenceValue(String propertyName) {
        ConfigProperty property = this.getProperty(propertyName);
        if (property instanceof ReferenceProperty) {
            return ((ReferenceProperty)property).getValue();
        }
        Activator.log.warn("The property " + propertyName + " is not a ReferenceProperty (Constraint " + this.descriptor.getName() + ")");
        return null;
    }

    protected void setDescriptor(SimpleConstraint descriptor) {
    }

    @Override
    public boolean match(Collection<?> selection) {
        if (selection.isEmpty()) {
            return false;
        }
        int elementMultiplicity = this.display.getElementMultiplicity();
        int selectionSize = selection.size();
        if (elementMultiplicity == 1) {
            if (selectionSize == 1 && this.match(this.first(selection))) {
                return true;
            }
        } else if (elementMultiplicity == selectionSize || elementMultiplicity < 0) {
            for (Object selectedItem : selection) {
                if (this.match(selectedItem)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    protected Object first(Collection<?> collection) {
        return collection instanceof List ? ((List)collection).get(0) : collection.iterator().next();
    }

    protected abstract boolean match(Object var1);
}

