/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.diagram.common.async;

import java.util.List;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.requests.GroupRequest;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.core.commands.DeleteCommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.uml2.diagram.common.async.AsyncDiagramDeleteRequest;
import org.eclipse.uml2.diagram.common.async.ICanonicalHelper;
import org.eclipse.uml2.diagram.common.async.SwitchSyncModeCommand;
import org.eclipse.uml2.diagram.common.editpolicies.InsertingComponentEditPolicy;

public class AsyncDiagramComponentEditPolicy
extends InsertingComponentEditPolicy {
    public AsyncDiagramComponentEditPolicy(boolean forListItem) {
        super(forListItem);
    }

    public AsyncDiagramComponentEditPolicy() {
        this(false);
    }

    public Command getCommand(Request request) {
        if (!(request instanceof GroupRequest)) {
            return null;
        }
        if (request instanceof AsyncDiagramDeleteRequest) {
            AsyncDiagramDeleteRequest reqImpl = (AsyncDiagramDeleteRequest)request;
            switch (reqImpl.getKind()) {
                case LET_TARGET_DECIDE: {
                    return this.getDeleteCommand(reqImpl);
                }
                case SEMANTIC_AND_NOTATION: {
                    return this.createDeleteSemanticCommand(reqImpl);
                }
                case NOTATION_ONLY: {
                    return this.createSwitchSyncAndDeleteViewCommand(reqImpl);
                }
            }
            throw new IllegalArgumentException("Unknown kind: " + (Object)((Object)reqImpl.getKind()));
        }
        return super.getCommand(request);
    }

    private Command createSwitchSyncAndDeleteViewCommand(AsyncDiagramDeleteRequest req) {
        TransactionalEditingDomain editingDomain = this.getHostImpl().getEditingDomain();
        List toDel = req.getEditParts();
        if (toDel == null || toDel.isEmpty()) {
            return new ICommandProxy(this.doCreateSwitchSyncAndDeleteViewCommand(editingDomain, this.getHostImpl()));
        }
        CompositeCommand cc = new CompositeCommand("");
        for (Object next : toDel) {
            IGraphicalEditPart nextEP = (IGraphicalEditPart)next;
            cc.compose((IUndoableOperation)this.doCreateSwitchSyncAndDeleteViewCommand(editingDomain, nextEP));
        }
        return new ICommandProxy(cc.reduce());
    }

    private ICommand doCreateSwitchSyncAndDeleteViewCommand(TransactionalEditingDomain domain, IGraphicalEditPart editPart) {
        EditPart parentEP = editPart.getParent();
        SwitchSyncModeCommand switchCommand = null;
        if (parentEP instanceof IGraphicalEditPart) {
            View parentView = ((IGraphicalEditPart)parentEP).getNotationView();
            if (this.getCanonicalHelper().isAutoSynchronized(parentView)) {
                switchCommand = new SwitchSyncModeCommand(domain, parentView, false);
            }
        }
        DeleteCommand deleteCommand = new DeleteCommand(domain, editPart.getNotationView());
        if (switchCommand == null) {
            return deleteCommand;
        }
        CompositeCommand result = new CompositeCommand(deleteCommand.getLabel());
        return result.compose((IUndoableOperation)switchCommand).compose((IUndoableOperation)deleteCommand);
    }

    private ICanonicalHelper getCanonicalHelper() {
        return ICanonicalHelper.IMPLEMENTATION;
    }
}

