/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.grammaranalysis.impl;

import org.eclipse.xtext.AbstractElement;
import org.eclipse.xtext.GrammarToDot;
import org.eclipse.xtext.grammaranalysis.IGrammarNFAProvider;
import org.eclipse.xtext.grammaranalysis.impl.DefaultForwardNFAProvider;
import org.eclipse.xtext.grammaranalysis.impl.DefaultNFAState;
import org.eclipse.xtext.grammaranalysis.impl.DefaultNFATransition;
import org.eclipse.xtext.util.GraphvizDotBuilder;

public class NFAToDot
extends GrammarToDot {
    protected IGrammarNFAProvider<DefaultNFAState, DefaultNFATransition> nfaProvider = new DefaultForwardNFAProvider();

    @Override
    protected GraphvizDotBuilder.Node drawAbstractElementTree(AbstractElement ele, GraphvizDotBuilder.Digraph d) {
        GraphvizDotBuilder.Node n = super.drawAbstractElementTree(ele, d);
        DefaultNFAState nfas = this.nfaProvider.getNFA(ele);
        for (DefaultNFATransition t : nfas.getOutgoing()) {
            d.add((GraphvizDotBuilder.Props)this.drawFollowerEdge(ele, t, false));
        }
        for (DefaultNFATransition t : nfas.getOutgoingAfterReturn()) {
            d.add((GraphvizDotBuilder.Props)this.drawFollowerEdge(ele, t, true));
        }
        if (nfas.getOutgoing().size() == 0 && nfas.getOutgoingAfterReturn().size() == 0 && !nfas.isEndState()) {
            n.setStyle("dotted");
        }
        if (nfas.isEndState()) {
            n.put((Object)"peripheries", (Object)"2");
        }
        return n;
    }

    protected GraphvizDotBuilder.Edge drawFollowerEdge(AbstractElement ele, DefaultNFATransition t, boolean isParent) {
        GraphvizDotBuilder.Edge e = new GraphvizDotBuilder.Edge((GraphvizDotBuilder)this, (Object)ele, (Object)((DefaultNFAState)t.getTarget()).getGrammarElement());
        e.setLabel(String.valueOf(t.getPrecedence()));
        e.setStyle("dotted");
        if (isParent) {
            e.put((Object)"arrowtail", (Object)"odot");
        }
        if (t.isRuleCall()) {
            e.put((Object)"arrowhead", (Object)"onormalonormal");
        } else {
            e.put((Object)"arrowhead", (Object)"onormal");
        }
        return e;
    }
}

