/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.mpc.ui.catalog;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.concurrent.Callable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.epp.internal.mpc.core.util.TransportFactory;
import org.eclipse.epp.internal.mpc.ui.MarketplaceClientUi;
import org.eclipse.epp.internal.mpc.ui.catalog.Messages;
import org.eclipse.epp.internal.mpc.ui.catalog.ResourceProvider;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbstractResourceRunnable
implements IRunnableWithProgress,
Callable<Object> {
    protected ResourceProvider resourceProvider;
    protected String resourceUrl;
    private final IProgressMonitor cancellationMonitor;

    public AbstractResourceRunnable(IProgressMonitor cancellationMonitor, ResourceProvider resourceProvider, String resourceUrl) {
        this.cancellationMonitor = cancellationMonitor;
        this.resourceProvider = resourceProvider;
        this.resourceUrl = resourceUrl;
    }

    @Override
    public Object call() throws Exception {
        this.run((IProgressMonitor)new NullProgressMonitor(){

            public boolean isCanceled() {
                return AbstractResourceRunnable.this.cancellationMonitor.isCanceled();
            }
        });
        return this;
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        try {
            URL imageUrl = new URL(this.resourceUrl);
            InputStream in = TransportFactory.instance().getTransport().stream(imageUrl.toURI(), monitor);
            try {
                this.resourceProvider.putResource(this.resourceUrl, in);
            }
            finally {
                in.close();
            }
        }
        catch (URISyntaxException e) {
            MarketplaceClientUi.error(NLS.bind((String)Messages.AbstractResourceRunnable_badUri, (Object)this.resourceUrl), e);
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException e) {
            MarketplaceClientUi.error(e);
        }
        catch (CoreException e) {
            MarketplaceClientUi.error(e);
        }
        if (this.resourceProvider.containsResource(this.resourceUrl)) {
            this.resourceRetrieved();
        }
    }

    protected abstract void resourceRetrieved();
}

