/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.commonmark.internal.inlines;

import java.util.List;
import org.eclipse.mylyn.wikitext.commonmark.internal.Line;
import org.eclipse.mylyn.wikitext.commonmark.internal.ProcessingContext;
import org.eclipse.mylyn.wikitext.commonmark.internal.inlines.Cursor;
import org.eclipse.mylyn.wikitext.commonmark.internal.inlines.Inline;
import org.eclipse.mylyn.wikitext.commonmark.internal.inlines.InlineWithText;
import org.eclipse.mylyn.wikitext.parser.DocumentBuilder;

public class Characters
extends InlineWithText {
    public Characters(Line line, int offset, int length, String text) {
        super(line, offset, length, text);
    }

    @Override
    public void emit(DocumentBuilder builder) {
        builder.characters(this.text);
    }

    @Override
    public void apply(ProcessingContext context, List<Inline> inlines, Cursor cursor) {
        Inline last;
        cursor.advance(this.getLength());
        if (!inlines.isEmpty() && (last = inlines.get(inlines.size() - 1)) instanceof Characters) {
            Characters lastCharacters = (Characters)last;
            int newLength = lastCharacters.getLength() + this.getLength();
            String newText = lastCharacters.getText() + this.getText();
            Characters substitution = new Characters(lastCharacters.getLine(), lastCharacters.getOffset(), newLength, newText);
            inlines.set(inlines.size() - 1, substitution);
            return;
        }
        inlines.add(this);
    }
}

