/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.textile.internal.block;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.mylyn.wikitext.parser.Attributes;
import org.eclipse.mylyn.wikitext.parser.DocumentBuilder;
import org.eclipse.mylyn.wikitext.parser.markup.Block;
import org.eclipse.mylyn.wikitext.textile.TextileLanguage;
import org.eclipse.mylyn.wikitext.textile.internal.Textile;

public class ParagraphBlock
extends Block {
    private static final int LINE_REMAINDER_GROUP_OFFSET = 8;
    static final Pattern startPattern = Pattern.compile("p(\\(+)?(\\)+)?(\\<|\\>|\\=|\\<\\>)?(?:(?:\\(([^#\\)]+)?(?:#([^\\(\\)]+))?\\))|(?:\\{([^\\{\\}]+)\\})|(?:\\[([^\\[\\]]+)\\])){0,3}\\.\\s+(.*)");
    private int blockLineCount = 0;
    private boolean unwrapped = false;
    private boolean enableUnwrapped = true;

    public int processLineContent(String line, int offset) {
        if (this.blockLineCount == 0) {
            Attributes attributes = new Attributes();
            if (offset == 0) {
                Matcher matcher = startPattern.matcher(line);
                if (matcher.matches()) {
                    Textile.configureAttributes(attributes, matcher, 1, true);
                    offset = matcher.start(8);
                } else if (line.charAt(0) == ' ') {
                    offset = 1;
                    if (this.enableUnwrapped) {
                        this.unwrapped = true;
                    }
                }
            }
            if (!this.unwrapped) {
                this.builder.beginBlock(DocumentBuilder.BlockType.PARAGRAPH, attributes);
            }
        }
        if (this.markupLanguage.isEmptyLine(line)) {
            this.setClosed(true);
            return 0;
        }
        TextileLanguage textileLanguage = (TextileLanguage)this.getMarkupLanguage();
        for (Block block : textileLanguage.getParagraphBreakingBlocks()) {
            if (!block.canStart(line, offset)) continue;
            this.setClosed(true);
            return 0;
        }
        if (this.blockLineCount != 0) {
            if (this.unwrapped) {
                this.builder.characters("\n");
            } else {
                this.builder.lineBreak();
            }
        }
        ++this.blockLineCount;
        textileLanguage.emitMarkupLine(this.getParser(), this.state, line, offset);
        return -1;
    }

    public boolean canStart(String line, int lineOffset) {
        this.unwrapped = false;
        this.blockLineCount = 0;
        return true;
    }

    public void setClosed(boolean closed) {
        if (closed && !this.isClosed() && !this.unwrapped) {
            this.builder.endBlock();
        }
        super.setClosed(closed);
    }

    public void setEnableUnwrapped(boolean enableUnwrapped) {
        this.enableUnwrapped = enableUnwrapped;
    }

    public boolean isEnableUnwrapped() {
        return this.enableUnwrapped;
    }
}

