/*
 * Copyright (c) 2015 Goldman Sachs.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * and Eclipse Distribution License v. 1.0 which accompany this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 */

/**
 * This package contains implementations of {@link org.eclipse.collections.api.tuple.Pair}, {@link org.eclipse.collections.api.tuple.Twin},
 * {@link org.eclipse.collections.api.tuple.Triple} and {@link org.eclipse.collections.api.tuple.Triplet} interfaces.
 * <p>
 *     A tuple is a container that holds two related objects.
 * <p>
 *     This package contains the following implementations:
 * <ul>
 *     <li>
 *          {@link org.eclipse.collections.impl.tuple.ImmutableEntry} - an immutable {@link java.util.Map.Entry}.
 *     </li>
 *     <li>
 *          {@link org.eclipse.collections.impl.tuple.PairImpl} - a container that holds two related objects.
 *     </li>
 *     <li>
 *          {@link org.eclipse.collections.impl.tuple.Tuples} - a container that holds two related objects.
 *     </li>
 *     <li>
 *          {@link org.eclipse.collections.impl.tuple.TwinImpl} - a convenience class for PairImpl, that has the same type for both items.
 *     </li>
 * </ul>
 */
package org.eclipse.collections.impl.tuple;
