/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.set.immutable.primitive;

import org.eclipse.collections.api.ShortIterable;
import org.eclipse.collections.api.factory.set.primitive.ImmutableShortSetFactory;
import org.eclipse.collections.api.set.primitive.ImmutableShortSet;
import org.eclipse.collections.impl.factory.primitive.ShortSets;
import org.eclipse.collections.impl.set.immutable.primitive.ImmutableShortEmptySet;
import org.eclipse.collections.impl.set.immutable.primitive.ImmutableShortSingletonSet;
import org.eclipse.collections.impl.set.mutable.primitive.ShortHashSet;

public enum ImmutableShortSetFactoryImpl implements ImmutableShortSetFactory
{
    INSTANCE;


    @Override
    public ImmutableShortSet empty() {
        return ImmutableShortEmptySet.INSTANCE;
    }

    @Override
    public ImmutableShortSet of() {
        return this.empty();
    }

    @Override
    public ImmutableShortSet with() {
        return this.empty();
    }

    @Override
    public ImmutableShortSet of(short one) {
        return this.with(one);
    }

    @Override
    public ImmutableShortSet with(short one) {
        return new ImmutableShortSingletonSet(one);
    }

    @Override
    public ImmutableShortSet of(short ... items) {
        return this.with(items);
    }

    @Override
    public ImmutableShortSet with(short ... items) {
        if (items == null || items.length == 0) {
            return this.with();
        }
        if (items.length == 1) {
            return this.with(items[0]);
        }
        return ShortHashSet.newSetWith(items).toImmutable();
    }

    @Override
    public ImmutableShortSet ofAll(ShortIterable items) {
        return this.withAll(items);
    }

    @Override
    public ImmutableShortSet withAll(ShortIterable items) {
        if (items instanceof ImmutableShortSet) {
            return (ImmutableShortSet)items;
        }
        return this.with(items.toArray());
    }

    @Override
    public ImmutableShortSet ofAll(Iterable<Short> iterable) {
        return this.withAll(iterable);
    }

    @Override
    public ImmutableShortSet withAll(Iterable<Short> iterable) {
        return ShortSets.mutable.withAll(iterable).toImmutable();
    }
}

