/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.base.util;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.resource.impl.ResourceImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xml.type.XMLTypeFactory;
import org.eclipse.oomph.base.Annotation;
import org.eclipse.oomph.base.BaseFactory;
import org.eclipse.oomph.base.BasePackage;
import org.eclipse.oomph.base.util.BytesResource;
import org.eclipse.oomph.util.IOUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BytesResourceImpl
extends ResourceImpl
implements BytesResource {
    public BytesResourceImpl(URI uri) {
        super(uri);
    }

    protected void doLoad(InputStream inputStream, Map<?, ?> options) throws IOException {
        ByteArrayOutputStream bytes = null;
        try {
            bytes = new ByteArrayOutputStream();
            IOUtil.copy((InputStream)inputStream, (OutputStream)bytes);
            String value = XMLTypeFactory.eINSTANCE.convertBase64Binary(bytes.toByteArray());
            Annotation annotation = BaseFactory.eINSTANCE.createAnnotation();
            annotation.setSource(value);
            this.getContents().add((Object)annotation);
        }
        finally {
            IOUtil.closeSilent((Closeable)bytes);
        }
    }

    protected void doSave(OutputStream outputStream, Map<?, ?> options) throws IOException {
        String value;
        Annotation annotation = (Annotation)EcoreUtil.getObjectByType((Collection)this.getContents(), (EClassifier)BasePackage.Literals.ANNOTATION);
        if (annotation != null && (value = annotation.getSource()) != null) {
            outputStream.write(XMLTypeFactory.eINSTANCE.createBase64Binary(value));
        }
    }
}

