/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.ui;

import org.eclipse.oomph.ui.ActivityAdapter;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;

public abstract class InactivityDetector {
    private final ActivityAdapter activityAdapter = new ActivityAdapter(){

        protected void handleActivity() {
            InactivityDetector.this.resetLastActivity();
            if (InactivityDetector.this.inactive) {
                InactivityDetector.this.inactive = false;
                InactivityDetector.this.handleInactivity(InactivityDetector.this.display, InactivityDetector.this.inactive);
            }
        }
    };
    private final int detectorInterval;
    private final int inactivityThreshold;
    private boolean inactive;
    private long lastActivity;
    private Display display;

    public InactivityDetector(int detectorInterval, int inactivityThreshold) {
        this.detectorInterval = detectorInterval;
        this.inactivityThreshold = inactivityThreshold;
        this.resetLastActivity();
    }

    public final boolean isInactive() {
        return this.inactive;
    }

    public final void monitor(final Control control) {
        final Display controlDisplay = control.getDisplay();
        controlDisplay.asyncExec(new Runnable(){

            public void run() {
                if (!control.isDisposed()) {
                    InactivityDetector.this.activityAdapter.attach(control);
                    if (InactivityDetector.this.display == null) {
                        InactivityDetector.this.display = controlDisplay;
                        InactivityDetector.this.display.timerExec(InactivityDetector.this.detectorInterval, new Runnable(){

                            public void run() {
                                if (!control.isDisposed()) {
                                    if (System.currentTimeMillis() - InactivityDetector.this.lastActivity > (long)InactivityDetector.this.inactivityThreshold && !InactivityDetector.this.inactive) {
                                        InactivityDetector.this.inactive = true;
                                        InactivityDetector.this.handleInactivity(InactivityDetector.this.display, InactivityDetector.this.inactive);
                                    }
                                    if (!InactivityDetector.this.display.isDisposed()) {
                                        InactivityDetector.this.display.timerExec(InactivityDetector.this.detectorInterval, (Runnable)this);
                                    }
                                }
                            }
                        });
                    }
                }
            }
        });
    }

    protected abstract void handleInactivity(Display var1, boolean var2);

    private void resetLastActivity() {
        this.lastActivity = System.currentTimeMillis();
    }
}

