/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.targlets.internal.core.listeners;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.xmi.XMLHelper;
import org.eclipse.emf.ecore.xmi.impl.XMLSaveImpl;
import org.eclipse.equinox.internal.p2.metadata.IRequiredCapability;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IRequirement;
import org.eclipse.equinox.p2.metadata.IVersionedId;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.VersionedId;
import org.eclipse.equinox.p2.metadata.expression.IExpression;
import org.eclipse.equinox.p2.query.IQueryable;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.eclipse.oomph.base.Annotation;
import org.eclipse.oomph.p2.Repository;
import org.eclipse.oomph.p2.Requirement;
import org.eclipse.oomph.p2.core.Profile;
import org.eclipse.oomph.p2.internal.core.RootAnalyzer;
import org.eclipse.oomph.targlets.Targlet;
import org.eclipse.oomph.targlets.core.ITargletContainer;
import org.eclipse.oomph.targlets.core.TargletContainerEvent;
import org.eclipse.oomph.targlets.core.WorkspaceIUInfo;
import org.eclipse.oomph.targlets.internal.core.TargletsCorePlugin;
import org.eclipse.oomph.targlets.internal.core.listeners.FileUpdater;
import org.eclipse.oomph.targlets.internal.core.listeners.WorkspaceUpdateListener;
import org.eclipse.oomph.util.CollectionUtil;
import org.eclipse.oomph.util.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TargetDefinitionGenerator
extends WorkspaceUpdateListener {
    public static final String ANNOTATION = "http:/www.eclipse.org/oomph/targlets/TargetDefinitionGenerator";
    public static final String ANNOTATION_NAME = "name";
    public static final String ANNOTATION_LOCATION = "location";
    public static final String ANNOTATION_PREFERRED_REPOSITORIES = "preferredRepositories";
    public static final String ANNOTATION_GENERATE_IMPLICIT_UNITS = "generateImplicitUnits";
    public static final String ANNOTATION_GENERATE_VERSIONS = "generateVersions";
    public static final String ANNOTATION_INCLUDE_ALL_PLATFORMS = "includeAllPlatforms";
    public static final String ANNOTATION_INCLUDE_CONFIGURE_PHASE = "includeConfigurePhase";
    public static final String ANNOTATION_INCLUDE_MODE = "includeMode";
    public static final String ANNOTATION_INCLUDE_SOURCE = "includeSource";
    public static final String ANNOTATION_EXTRA_UNITS = "extraUnits";
    public static final String ANNOTATION_SINGLE_LOCATION = "singleLocation";
    private static final Pattern SEQUENCE_NUMBER_PATTERN = Pattern.compile("sequenceNumber=\"([0-9]+)\"");
    private static final String TRUE = Boolean.TRUE.toString();

    @Override
    protected void handleTargletContainerEvent(TargletContainerEvent.ProfileUpdateSucceededEvent profileUpdateSucceededEvent, TargletContainerEvent.WorkspaceUpdateFinishedEvent workspaceUpdateFinishedEvent, IProgressMonitor monitor) throws Exception {
        ITargletContainer targletContainer = profileUpdateSucceededEvent.getSource();
        for (Targlet targlet : targletContainer.getTarglets()) {
            Annotation annotation = targlet.getAnnotation(ANNOTATION);
            if (annotation == null) continue;
            Profile profile = profileUpdateSucceededEvent.getProfile();
            IInstallableUnit artificialRoot = profileUpdateSucceededEvent.getArtificialRoot();
            List<IMetadataRepository> metadataRepositories = profileUpdateSucceededEvent.getMetadataRepositories();
            Map<IInstallableUnit, WorkspaceIUInfo> workspaceIUInfos = profileUpdateSucceededEvent.getWorkspaceIUInfos();
            TargetDefinitionGenerator.generateTargetDefinition(targlet, annotation, profile, artificialRoot, metadataRepositories, workspaceIUInfos, monitor);
        }
    }

    private static void generateTargetDefinition(Targlet targlet, Annotation annotation, Profile profile, IInstallableUnit artificialRoot, List<IMetadataRepository> metadataRepositories, Map<IInstallableUnit, WorkspaceIUInfo> workspaceIUInfos, final IProgressMonitor monitor) throws Exception {
        monitor.setTaskName("Checking for generated target definition updates");
        EMap details = annotation.getDetails();
        String targletName = (String)details.get((Object)ANNOTATION_NAME);
        final String name = StringUtil.isEmpty((String)targletName) ? "Generated from " + targlet.getName() : targletName;
        String location = (String)details.get((Object)ANNOTATION_LOCATION);
        if (StringUtil.isEmpty((String)location)) {
            location = File.createTempFile("tmp-", ".target").getAbsolutePath();
            TargletsCorePlugin.INSTANCE.log("Generating target definition for targlet " + targlet.getName() + " to " + location);
        }
        File targetDefinition = new File(location);
        Set<IVersionedId> extraUnits = TargetDefinitionGenerator.getExtraUnits(annotation);
        List<String> preferredURLs = TargetDefinitionGenerator.getPreferredRepositories(annotation);
        final boolean singleLocation = TargetDefinitionGenerator.isAnnotationDetail(annotation, ANNOTATION_SINGLE_LOCATION, false);
        boolean generateImplicitUnits = TargetDefinitionGenerator.isAnnotationDetail(annotation, ANNOTATION_GENERATE_IMPLICIT_UNITS, false);
        final boolean versions = TargetDefinitionGenerator.isAnnotationDetail(annotation, ANNOTATION_GENERATE_VERSIONS, false);
        final boolean includeAllPlatforms = TargetDefinitionGenerator.isAnnotationDetail(annotation, ANNOTATION_INCLUDE_ALL_PLATFORMS, targlet.isIncludeAllPlatforms());
        final boolean includeConfigurePhase = TargetDefinitionGenerator.isAnnotationDetail(annotation, ANNOTATION_INCLUDE_CONFIGURE_PHASE, true);
        final String includeMode = TargetDefinitionGenerator.getAnnotationDetail(annotation, ANNOTATION_INCLUDE_MODE, targlet.isIncludeAllRequirements() ? "planner" : "slicer");
        final boolean includeSource = TargetDefinitionGenerator.isAnnotationDetail(annotation, ANNOTATION_INCLUDE_SOURCE, targlet.isIncludeSources());
        final Map<IMetadataRepository, Set<IInstallableUnit>> repositoryIUs = TargetDefinitionGenerator.analyzeRepositories(targlet, profile, artificialRoot, metadataRepositories, workspaceIUInfos, extraUnits, preferredURLs, generateImplicitUnits, singleLocation, monitor);
        new FileUpdater(){
            private int sequenceNumber;

            protected String createNewContents(String oldContents, String encoding, String nl) {
                Matcher matcher;
                if (oldContents != null && (matcher = SEQUENCE_NUMBER_PATTERN.matcher(oldContents)).find()) {
                    this.sequenceNumber = Integer.parseInt(matcher.group(1));
                }
                XML.Escaper escaper = new XML.Escaper(encoding);
                StringBuilder builder = new StringBuilder();
                builder.append("<?xml version=\"1.0\" encoding=\"" + encoding + "\" standalone=\"no\"?>");
                builder.append(nl);
                builder.append("<?pde version=\"3.8\"?>");
                builder.append(nl);
                builder.append("<target name=\"" + escaper.escape(name) + "\" sequenceNumber=\"" + this.sequenceNumber + "\">");
                builder.append(nl);
                builder.append("  <locations>");
                builder.append(nl);
                if (singleLocation) {
                    builder.append("    <location includeAllPlatforms=\"" + includeAllPlatforms + "\" includeConfigurePhase=\"" + includeConfigurePhase + "\" includeMode=\"" + includeMode + "\" includeSource=\"" + includeSource + "\" type=\"InstallableUnit\">");
                    builder.append(nl);
                    boolean first = true;
                    for (Map.Entry entry : repositoryIUs.entrySet()) {
                        ArrayList list;
                        IMetadataRepository repository = (IMetadataRepository)entry.getKey();
                        Set set = (Set)entry.getValue();
                        if (first && !(list = new ArrayList(set)).isEmpty()) {
                            LinkedHashSet<String> elements = new LinkedHashSet<String>();
                            Collections.sort(list);
                            for (IInstallableUnit iu : list) {
                                elements.add(this.formatElement(iu, versions, escaper));
                            }
                            for (String element : elements) {
                                builder.append("      ");
                                builder.append(element);
                                builder.append(nl);
                            }
                            first = false;
                        }
                        builder.append("      <repository location=\"" + escaper.escape(repository.getLocation()) + "\"/>");
                        builder.append(nl);
                    }
                    builder.append("    </location>");
                    builder.append(nl);
                } else {
                    for (Map.Entry entry : repositoryIUs.entrySet()) {
                        IMetadataRepository repository = (IMetadataRepository)entry.getKey();
                        Set set = (Set)entry.getValue();
                        ArrayList list = new ArrayList(set);
                        if (list.isEmpty()) continue;
                        builder.append("    <location includeAllPlatforms=\"" + includeAllPlatforms + "\" includeConfigurePhase=\"" + includeConfigurePhase + "\" includeMode=\"" + includeMode + "\" includeSource=\"" + includeSource + "\" type=\"InstallableUnit\">");
                        builder.append(nl);
                        LinkedHashSet<String> elements = new LinkedHashSet<String>();
                        Collections.sort(list);
                        for (IInstallableUnit iu : list) {
                            elements.add(this.formatElement(iu, versions, escaper));
                        }
                        for (String element : elements) {
                            builder.append("      ");
                            builder.append(element);
                            builder.append(nl);
                        }
                        builder.append("      <repository location=\"" + escaper.escape(repository.getLocation()) + "\"/>");
                        builder.append(nl);
                        builder.append("    </location>");
                        builder.append(nl);
                    }
                }
                builder.append("  </locations>");
                builder.append(nl);
                builder.append("</target>");
                builder.append(nl);
                return builder.toString();
            }

            protected void setContents(URI uri, String encoding, String contents) throws IOException {
                monitor.subTask("Updating " + (uri.isPlatformResource() ? uri.toPlatformString(true) : uri.toFileString()));
                contents = contents.replace("sequenceNumber=\"" + this.sequenceNumber + "\"", "sequenceNumber=\"" + (this.sequenceNumber + 1) + "\"");
                super.setContents(uri, encoding, contents);
            }

            private String formatElement(IInstallableUnit iu, boolean withVersion, XML.Escaper escaper) {
                Version version = iu.getVersion();
                if (!withVersion || version == null) {
                    version = Version.emptyVersion;
                }
                return "<unit id=\"" + escaper.escape(iu.getId()) + "\" version=\"" + escaper.escape(version) + "\"/>";
            }
        }.update(targetDefinition);
    }

    private static boolean isAnnotationDetail(Annotation annotation, String key, boolean defaultValue) {
        String detail = TargetDefinitionGenerator.getAnnotationDetail(annotation, key, Boolean.toString(defaultValue));
        return TRUE.equalsIgnoreCase(detail);
    }

    private static String getAnnotationDetail(Annotation annotation, String key, String defaultValue) {
        String value = (String)annotation.getDetails().get((Object)key);
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    private static Set<IVersionedId> getExtraUnits(Annotation annotation) {
        HashSet<IVersionedId> extraUnits = new HashSet<IVersionedId>();
        String values = (String)annotation.getDetails().get((Object)ANNOTATION_EXTRA_UNITS);
        if (!StringUtil.isEmpty((String)values)) {
            String[] stringArray = values.replace(',', ' ').split(" ");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String value = stringArray[n2];
                if (!StringUtil.isEmpty((String)value)) {
                    int pos = value.lastIndexOf(95);
                    String id = pos == -1 ? value : value.substring(0, pos);
                    Version version = pos == -1 ? Version.emptyVersion : Version.create((String)value.substring(pos + 1));
                    extraUnits.add((IVersionedId)new VersionedId(id, version));
                }
                ++n2;
            }
        }
        return extraUnits;
    }

    private static List<String> getPreferredRepositories(Annotation annotation) {
        ArrayList<String> preferredRepositories = new ArrayList<String>();
        String values = (String)annotation.getDetails().get((Object)ANNOTATION_PREFERRED_REPOSITORIES);
        if (!StringUtil.isEmpty((String)values)) {
            String[] stringArray = values.replace(',', ' ').split(" ");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String value = stringArray[n2];
                if (!StringUtil.isEmpty((String)value)) {
                    preferredRepositories.add(value);
                }
                ++n2;
            }
        }
        return preferredRepositories;
    }

    private static Map<IMetadataRepository, Set<IInstallableUnit>> analyzeRepositories(Targlet targlet, Profile profile, IInstallableUnit artificialRoot, List<IMetadataRepository> metadataRepositories, Map<IInstallableUnit, WorkspaceIUInfo> workspaceIUInfos, Set<IVersionedId> extraUnits, List<String> preferredURLs, boolean generateImplicitUnits, boolean singleLocation, IProgressMonitor monitor) {
        Set<IRequiredCapability> rootRequirements = TargetDefinitionGenerator.getRootRequirements(targlet, artificialRoot, workspaceIUInfos);
        HashSet<String> workspaceIDs = new HashSet<String>();
        for (IInstallableUnit iu : workspaceIUInfos.keySet()) {
            workspaceIDs.add(iu.getId());
        }
        HashSet<IInstallableUnit> resolvedIUs = new HashSet<IInstallableUnit>();
        for (IRequiredCapability requirement : rootRequirements) {
            TargetDefinitionGenerator.resolveRequirement(requirement, (IQueryable<IInstallableUnit>)profile, workspaceIDs, resolvedIUs, new HashSet<IRequiredCapability>());
        }
        Map<String, IMetadataRepository> queryables = TargetDefinitionGenerator.sortMetadataRepositories(targlet, metadataRepositories, preferredURLs, monitor);
        return TargetDefinitionGenerator.assignUnits(queryables, extraUnits, generateImplicitUnits, singleLocation, resolvedIUs, monitor);
    }

    private static Set<IRequiredCapability> getRootRequirements(Targlet targlet, IInstallableUnit artificialRoot, Map<IInstallableUnit, WorkspaceIUInfo> workspaceIUInfos) {
        HashMap profileRequirements = new HashMap();
        for (IRequirement profileRequirement : artificialRoot.getRequirements()) {
            if (!(profileRequirement instanceof IRequiredCapability)) continue;
            IRequiredCapability requiredCapability = (IRequiredCapability)profileRequirement;
            String id = String.valueOf(requiredCapability.getNamespace()) + "/" + requiredCapability.getName();
            CollectionUtil.add(profileRequirements, (Object)id, (Object)requiredCapability);
        }
        HashSet<IRequiredCapability> queue = new HashSet<IRequiredCapability>();
        for (Requirement targletRequirement : targlet.getRequirements()) {
            String namespace = targletRequirement.getNamespace();
            String name = targletRequirement.getName();
            if ("*".equals(name) && "org.eclipse.equinox.p2.iu".equals(namespace)) {
                for (IInstallableUnit iu : workspaceIUInfos.keySet()) {
                    for (IRequirement workspaceRequirement : iu.getRequirements()) {
                        if (!(workspaceRequirement instanceof IRequiredCapability)) continue;
                        IRequiredCapability requiredCapability = (IRequiredCapability)workspaceRequirement;
                        queue.add(requiredCapability);
                    }
                }
                continue;
            }
            String id = String.valueOf(namespace) + "/" + name;
            Set set = (Set)profileRequirements.get(id);
            if (set == null) continue;
            queue.addAll(set);
        }
        return queue;
    }

    private static void resolveRequirement(IRequiredCapability requirement, IQueryable<IInstallableUnit> queryable, Set<String> workspaceIDs, Set<IInstallableUnit> result, Set<IRequiredCapability> visited) {
        if (visited.add(requirement)) {
            for (IInstallableUnit iu : queryable.query(QueryUtil.createMatchQuery((IExpression)requirement.getMatches(), (Object[])new Object[0]), null)) {
                String id = iu.getId();
                if (id.endsWith(".source") || id.endsWith(".source.feature.group") || "true".equals(iu.getProperty("org.eclipse.oomph.targlet.source")) || workspaceIDs.contains(id) || !result.add(iu)) continue;
                for (IRequirement iuRequirement : iu.getRequirements()) {
                    if (!(iuRequirement instanceof IRequiredCapability)) continue;
                    TargetDefinitionGenerator.resolveRequirement((IRequiredCapability)iuRequirement, queryable, workspaceIDs, result, visited);
                }
            }
        }
    }

    private static Map<String, IMetadataRepository> sortMetadataRepositories(Targlet targlet, List<IMetadataRepository> metadataRepositories, List<String> preferredURLs, IProgressMonitor monitor) {
        String url;
        LinkedHashMap<String, IMetadataRepository> queryables = new LinkedHashMap<String, IMetadataRepository>();
        for (String urlPrefix : preferredURLs) {
            for (IMetadataRepository metadataRepository : metadataRepositories) {
                String url2 = metadataRepository.getLocation().toString();
                if (queryables.containsKey(url2) || !url2.startsWith(urlPrefix)) continue;
                queryables.put(url2, metadataRepository);
            }
        }
        for (Repository repository : targlet.getActiveRepositories()) {
            IMetadataRepository metadataRepository;
            TargletsCorePlugin.checkCancelation((IProgressMonitor)monitor);
            url = repository.getURL();
            if (queryables.containsKey(url) || (metadataRepository = TargetDefinitionGenerator.getMetadataRepository(url, metadataRepositories)) == null) continue;
            queryables.put(url, metadataRepository);
        }
        for (IMetadataRepository metadataRepository : metadataRepositories) {
            url = metadataRepository.getLocation().toString();
            if (queryables.containsKey(url)) continue;
            queryables.put(url, metadataRepository);
        }
        return queryables;
    }

    private static IMetadataRepository getMetadataRepository(String url, List<IMetadataRepository> metadataRepositories) {
        for (IMetadataRepository metadataRepository : metadataRepositories) {
            if (!metadataRepository.getLocation().toString().equals(url)) continue;
            return metadataRepository;
        }
        return null;
    }

    private static Map<IMetadataRepository, Set<IInstallableUnit>> assignUnits(Map<String, IMetadataRepository> queryables, Set<IVersionedId> extraUnits, boolean generateImplicitUnits, boolean singleLocation, Set<IInstallableUnit> resolvedIUs, IProgressMonitor monitor) {
        LinkedHashMap<IMetadataRepository, Set<IInstallableUnit>> result = new LinkedHashMap<IMetadataRepository, Set<IInstallableUnit>>();
        if (singleLocation) {
            IQueryable queryable = QueryUtil.compoundQueryable(queryables.values());
            boolean first = true;
            for (String url : queryables.keySet()) {
                IMetadataRepository metadataRepository = queryables.get(url);
                Set ius = CollectionUtil.getSet(result, (Object)metadataRepository);
                if (!first) continue;
                for (IVersionedId extraUnit : extraUnits) {
                    Iterator iterator = queryable.query(QueryUtil.createIUQuery((IVersionedId)extraUnit), null).iterator();
                    if (!iterator.hasNext()) continue;
                    IInstallableUnit extraIU = (IInstallableUnit)iterator.next();
                    ius.add(extraIU);
                }
                ius.addAll(resolvedIUs);
                if (!generateImplicitUnits) {
                    RootAnalyzer.removeImplicitUnits((Set)ius, (IQueryable)queryable, (IProgressMonitor)monitor);
                }
                first = false;
            }
        } else {
            for (String url : queryables.keySet()) {
                IMetadataRepository metadataRepository = queryables.get(url);
                Set ius = CollectionUtil.getSet(result, (Object)metadataRepository);
                Iterator<IVersionedId> it = extraUnits.iterator();
                while (it.hasNext()) {
                    IVersionedId extraUnit = it.next();
                    Iterator iterator = metadataRepository.query(QueryUtil.createIUQuery((IVersionedId)extraUnit), null).iterator();
                    if (!iterator.hasNext()) continue;
                    IInstallableUnit extraIU = (IInstallableUnit)iterator.next();
                    ius.add(extraIU);
                    it.remove();
                }
            }
            block4: for (IInstallableUnit iu : resolvedIUs) {
                for (IMetadataRepository metadataRepository : queryables.values()) {
                    if (metadataRepository.query(QueryUtil.createIUQuery((IVersionedId)iu), null).isEmpty()) continue;
                    CollectionUtil.add(result, (Object)metadataRepository, (Object)iu);
                    continue block4;
                }
            }
            if (!generateImplicitUnits) {
                RootAnalyzer.removeImplicitUnits(result, (IProgressMonitor)monitor);
            }
        }
        return result;
    }

    private static final class XML
    extends XMLSaveImpl {
        private XML(XMLHelper helper) {
            super(helper);
        }

        public static final class Escaper
        extends XMLSaveImpl.Escape {
            private static final int MAX_UTF_MAPPABLE_CODEPOINT = 0x10FFFF;
            private static final int MAX_LATIN1_MAPPABLE_CODEPOINT = 255;
            private static final int MAX_ASCII_MAPPABLE_CODEPOINT = 127;

            public Escaper(String encoding) {
                int maxSafeChar = 0x10FFFF;
                if (encoding != null) {
                    if (encoding.equalsIgnoreCase("ASCII") || encoding.equalsIgnoreCase("US-ASCII")) {
                        maxSafeChar = 127;
                    } else if (encoding.equalsIgnoreCase("ISO-8859-1")) {
                        maxSafeChar = 255;
                    }
                }
                this.setMappingLimit(maxSafeChar);
            }

            public String escape(Object value) {
                return this.convert(String.valueOf(value));
            }
        }
    }
}

