/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.gtk.GTK;
import org.eclipse.swt.internal.gtk.GtkRequisition;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.TypedListener;

public class Scale
extends Control {
    public Scale(Composite parent, int style) {
        super(parent, Scale.checkStyle(style));
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    static int checkStyle(int style) {
        return Scale.checkBits(style, 256, 512, 0, 0, 0, 0);
    }

    @Override
    Point computeSizeInPixels(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        if (wHint != -1 && wHint < 0) {
            wHint = 0;
        }
        if (hHint != -1 && hHint < 0) {
            hHint = 0;
        }
        Point size = this.computeNativeSize(this.handle, wHint, hHint, changed);
        if ((this.style & 0x100) != 0) {
            if (wHint == -1) {
                size.x = 2 * size.x;
            }
        } else if (hHint == -1) {
            size.y = 2 * size.y;
        }
        return size;
    }

    @Override
    void createHandle(int index) {
        this.state |= 0x10008;
        this.fixedHandle = OS.g_object_new(this.display.gtk_fixed_get_type(), 0L);
        if (this.fixedHandle == 0L) {
            this.error(2);
        }
        this.gtk_widget_set_has_surface_or_window(this.fixedHandle, true);
        long hAdjustment = GTK.gtk_adjustment_new(0.0, 0.0, 100.0, 1.0, 10.0, 0.0);
        if (hAdjustment == 0L) {
            this.error(2);
        }
        this.handle = (this.style & 0x100) != 0 ? GTK.gtk_scale_new(0, hAdjustment) : GTK.gtk_scale_new(1, hAdjustment);
        if (this.handle == 0L) {
            this.error(2);
        }
        if (GTK.GTK4) {
            OS.swt_fixed_add(this.fixedHandle, this.handle);
        } else {
            GTK.gtk_container_add(this.fixedHandle, this.handle);
        }
        GTK.gtk_scale_set_digits(this.handle, 0);
        GTK.gtk_scale_set_draw_value(this.handle, false);
    }

    @Override
    void hookEvents() {
        super.hookEvents();
        OS.g_signal_connect_closure(this.handle, OS.value_changed, this.display.getClosure(57), false);
    }

    public int getIncrement() {
        this.checkWidget();
        long hAdjustment = GTK.gtk_range_get_adjustment(this.handle);
        return (int)GTK.gtk_adjustment_get_step_increment(hAdjustment);
    }

    public int getMaximum() {
        this.checkWidget();
        long hAdjustment = GTK.gtk_range_get_adjustment(this.handle);
        return (int)GTK.gtk_adjustment_get_upper(hAdjustment);
    }

    public int getMinimum() {
        this.checkWidget();
        long hAdjustment = GTK.gtk_range_get_adjustment(this.handle);
        return (int)GTK.gtk_adjustment_get_lower(hAdjustment);
    }

    public int getPageIncrement() {
        this.checkWidget();
        long hAdjustment = GTK.gtk_range_get_adjustment(this.handle);
        return (int)GTK.gtk_adjustment_get_page_increment(hAdjustment);
    }

    public int getSelection() {
        this.checkWidget();
        long hAdjustment = GTK.gtk_range_get_adjustment(this.handle);
        return (int)GTK.gtk_adjustment_get_value(hAdjustment);
    }

    @Override
    long gtk_value_changed(long adjustment) {
        this.sendSelectionEvent(13);
        return 0L;
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, listener);
        this.eventTable.unhook(14, listener);
    }

    public void setIncrement(int increment) {
        this.checkWidget();
        if (increment < 1) {
            return;
        }
        OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0L, 0L, 57L);
        GTK.gtk_range_set_increments(this.handle, increment, this.getPageIncrement());
        OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0L, 0L, 57L);
    }

    public void setMaximum(int value) {
        this.checkWidget();
        int minimum = this.getMinimum();
        if (value <= minimum) {
            return;
        }
        OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0L, 0L, 57L);
        GTK.gtk_range_set_range(this.handle, minimum, value);
        OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0L, 0L, 57L);
    }

    public void setMinimum(int value) {
        this.checkWidget();
        if (value < 0) {
            return;
        }
        int maximum = this.getMaximum();
        if (value >= maximum) {
            return;
        }
        OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0L, 0L, 57L);
        GTK.gtk_range_set_range(this.handle, value, maximum);
        OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0L, 0L, 57L);
    }

    public void setPageIncrement(int pageIncrement) {
        this.checkWidget();
        if (pageIncrement < 1) {
            return;
        }
        OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0L, 0L, 57L);
        GTK.gtk_range_set_increments(this.handle, this.getIncrement(), pageIncrement);
        OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0L, 0L, 57L);
    }

    public void setSelection(int value) {
        this.checkWidget();
        OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0L, 0L, 57L);
        GTK.gtk_range_set_value(this.handle, value);
        OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0L, 0L, 57L);
    }

    @Override
    Point resizeCalculationsGTK3(long widget, int width, int height) {
        Point size = super.resizeCalculationsGTK3(widget, width, height);
        if (widget == this.handle) {
            GtkRequisition naturalSize = new GtkRequisition();
            GtkRequisition minimumSize = new GtkRequisition();
            GTK.gtk_widget_get_preferred_size(this.handle, minimumSize, naturalSize);
            if ((this.style & 0x200) != 0) {
                size.x = Math.max(size.x, minimumSize.width);
            }
            if ((this.style & 0x100) != 0) {
                size.y = Math.max(size.y, minimumSize.height);
            }
        }
        return size;
    }
}

