/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.internal.bc;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Objects;
import java.util.function.Supplier;
import org.bouncycastle.crypto.digests.SHA512Digest;
import org.eclipse.passage.lic.internal.base.io.FileContent;

public final class BcDigest
implements Supplier<byte[]> {
    private final byte[] source;

    public BcDigest(byte[] source) {
        Objects.requireNonNull(source, "BcDigest::source");
        this.source = source;
    }

    public BcDigest(Path source) throws IOException {
        this(new FileContent(source).get());
    }

    @Override
    public byte[] get() {
        SHA512Digest digest = new SHA512Digest();
        digest.reset();
        digest.update(this.source, 0, this.source.length);
        byte[] data = new byte[digest.getDigestSize()];
        digest.doFinal(data, 0);
        return data;
    }
}

