/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.internal.net.handle;

import java.util.Optional;
import org.eclipse.passage.lic.internal.api.LicensedProduct;
import org.eclipse.passage.lic.internal.api.LicensingException;
import org.eclipse.passage.lic.internal.base.BaseLicensedProduct;
import org.eclipse.passage.lic.internal.base.ProductIdentifier;
import org.eclipse.passage.lic.internal.base.ProductVersion;
import org.eclipse.passage.lic.internal.net.LicenseUser;
import org.eclipse.passage.lic.internal.net.api.handle.NetRequest;
import org.eclipse.passage.lic.internal.net.handle.DecodedParam;

public final class ProductUserRequest<R extends NetRequest> {
    private final R raw;
    private final Optional<LicensedProduct> product;
    private final Optional<String> user;

    public ProductUserRequest(R raw) throws LicensingException {
        this.raw = raw;
        this.product = this.extractProduct();
        this.user = this.extractUser();
    }

    private Optional<LicensedProduct> extractProduct() throws LicensingException {
        Optional id = new ProductIdentifier(arg_0 -> this.raw.parameter(arg_0)).get();
        Optional version = new ProductVersion(arg_0 -> this.raw.parameter(arg_0)).get();
        if (!id.isPresent() || !version.isPresent()) {
            return Optional.empty();
        }
        return Optional.of(new BaseLicensedProduct(new DecodedParam((String)id.get()).get(), new DecodedParam((String)version.get()).get()));
    }

    private Optional<String> extractUser() {
        return new LicenseUser(arg_0 -> this.raw.parameter(arg_0)).get();
    }

    public R raw() {
        return this.raw;
    }

    public Optional<LicensedProduct> product() {
        return this.product;
    }

    public Optional<String> user() {
        return this.user;
    }
}

